(function ($) {
    "use strict";

    const link = document.querySelectorAll('.bayone-social-media .hover-this');
    const animateit = function (e) {
        const hoverAnim = this.querySelector('.bayone-social-media .hover-anim');
        const { offsetX: x, offsetY: y } = e,
            { offsetWidth: width, offsetHeight: height } = this,
            move = 25,
            xMove = x / width * (move * 2) - move,
            yMove = y / height * (move * 2) - move;
        hoverAnim.style.transform = `translate(${xMove}px, ${yMove}px)`;
        if (e.type === 'mouseleave') hoverAnim.style.transform = '';
    };

    link.forEach(b => b.addEventListener('mousemove', animateit));
    link.forEach(b => b.addEventListener('mouseleave', animateit));
})(jQuery);

(function ($) {
    "use strict";
    window.onload = function(){
        
        if ($('.bayone-sticky-bottom')[0] && !$('body').hasClass("elementor-editor-active")) {
            $('.blank-builder').addClass('bayone-fixed-container');
            gsap.set('.site-footer', { yPercent: -50 })
            const uncover = gsap.timeline({ paused: true })
            uncover.to('.site-footer', { yPercent: 0, ease: 'none' });
            ScrollTrigger.create({
                trigger: '.blank-builder',
                start: 'bottom bottom',
                end: '+=50%',
                animation: uncover,
                scrub: true,
            });
        }
    }
})(jQuery);