(function ($) {
    "use strict";

    if ($(".bayone-nav.animated-text")) {
        let elements = document.querySelectorAll(".bayone-nav.animated-text .main-menu ul .menu-item > a");

        elements.forEach((element) => {
            let innerText = element.innerText;
            element.innerHTML = "";

            let textContainer = document.createElement("span");
            let animationContainer = document.createElement("span");
            animationContainer.classList.add("rolling-text")
            textContainer.classList.add("block");

            for (let letter of innerText) {
                let span = document.createElement("span");
                span.innerText = letter.trim() === "" ? "\xa0" : letter;
                span.classList.add("letter");
                textContainer.appendChild(span);
            }

            animationContainer.appendChild(textContainer);
            animationContainer.appendChild(textContainer.cloneNode(true));

            element.appendChild(animationContainer);
        });

        elements.forEach((element) => {
            element.addEventListener("mouseover", () => {
                element.classList.remove("play");
            });
        });
    }

    $(window).on("load", function () {
        let elements = document.querySelectorAll(".bayone-nav.menu-list");

        elements.forEach((element) => {
            let elementsChild = element.querySelectorAll(".main-menu ul .menu-item > a");
            let count = 1;
            elementsChild.forEach((child) => {
                let countString = count < 10 ? '0' + count : count;
                let span = document.createElement("span");
                span.classList.add('nm');
                span.textContent = countString + '.';
                child.prepend(span);  // Use prepend to insert at the beginning of the child element
                count++;
            });
        });

        $('.bayone-nav.menu-list .menu-item-has-children').append('<i></i>')

        $('.bayone-nav.menu-list .menu-item-has-children').on('click', function () {
            $(this).children('.sub-menu').toggleClass('sub-open');
            $(this).toggleClass('sub-menu-open');
        });

        $('.bayone-nav.menu-list .navigation > .menu-item').on('mouseenter', function () {
            $(this).css("opacity", "1").siblings().css("opacity", ".5");
        });

        $('.bayone-nav.menu-list .navigation > .menu-item').on('mouseleave', function () {
            $(this).css("opacity", "1").siblings().css("opacity", "1");
        });
    });


})(jQuery);