(function ($) {
    "use strict";
    
    if($(".bayone-nav.animated-text")){
        let elements = document.querySelectorAll(".bayone-nav.animated-text .main-menu ul .menu-item > a");

        elements.forEach((element) => {
            let innerText = element.innerText;
            element.innerHTML = "";

            let textContainer = document.createElement("span");
            let animationContainer = document.createElement("span");
            animationContainer.classList.add("rolling-text")
            textContainer.classList.add("block");

            for (let letter of innerText) {
                let span = document.createElement("span");
                span.innerText = letter.trim() === "" ? "\xa0" : letter;
                span.classList.add("letter");
                textContainer.appendChild(span);
            }

            animationContainer.appendChild(textContainer);
            animationContainer.appendChild(textContainer.cloneNode(true));

            element.appendChild(animationContainer);
        });

        elements.forEach((element) => {
            element.addEventListener("mouseover", () => {
                element.classList.remove("play");
            });
        });
    }

    $(window).on("load", function () {
        let elements = document.querySelectorAll(".bayone-nav.menu-list .main-menu ul .menu-item > a");

        elements.forEach((element) => {
            let innerText = element.innerText;

            $(element).attr('data-text', innerText)
        });      
        
        $('.bayone-nav.menu-list .menu-item-has-children').append('<i></i>')

        $('.bayone-nav.menu-list .menu-item-has-children').on('click', function () {
            $(this).children('.sub-menu').toggleClass('sub-open');
            $(this).toggleClass('sub-menu-open');
        });

        $('.bayone-nav.menu-list .navigation > .menu-item').on('mouseenter', function () {
            $(this).removeClass('hoverd').siblings().addClass('hoverd');
        });

        let menuItems = $('.bayone-nav.menu-list .navigation > .menu-item');
        
        let count = 1;

        menuItems.forEach((menuItem) => {
            let content = menuItem.innerText:
            countString = count < 10 ? '0' + count : count;
            menuItem.append(countString, content);
            count++;
        })
    
        $('.bayone-nav.menu-list .navigation > .menu-item').on('mouseleave', function () {
            $(this).removeClass('hoverd').siblings().removeClass('hoverd');
        });
    });


})(jQuery);