<?php
namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Utils;

if (!defined('ABSPATH')) exit;

class Bayone_Accordion_Bord extends Widget_Base
{
    public function get_name()
    {
        return 'bayone-accordion-accordion-bord';
    }

    public function get_title()
    {
        return __('Accordion Bord Section', 'bayone_plg');
    }

    public function get_icon()
    {
        return 'eicon-accordion';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    public function get_script_depends() {
        return [ 'bayone-accordion'];
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_items',
            [
                'label' => __('Accordion Items', 'bayone_plg'),
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'item_title',
            [
                'label' => __('Title', 'bayone_plg'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Accordion Item', 'bayone_plg'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'item_content',
            [
                'label' => __('Content', 'bayone_plg'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Accordion item content...', 'bayone_plg'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'item_delay',
            [
                'label' => __('Animation Delay', 'bayone_plg'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 0.1,
                'description' => __('Enter the animation delay in seconds for this item.', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'accordion_items',
            [
                'label' => __('Accordion Items', 'bayone_plg'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ item_title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__( 'Style Section', 'textdomain' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'bayone_plg'),
                'selector' => '{{WRAPPER}} .bayone-accordion-bord .title h4',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'bayone_plg'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .bayone-accordion-bord .title h4' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'text_typography',
                'label' => __('Text Typography', 'bayone_plg'),
                'selector' => '{{WRAPPER}} .bayone-accordion-bord .accordion-info p',
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label' => __('Text Color', 'bayone_plg'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ddd',
                'selectors' => [
                    '{{WRAPPER}} .bayone-accordion-bord .accordion-info p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="bayone-accordion-bord">
            <div class="accordion bord">
                <?php foreach ($settings['accordion_items'] as $index => $item) : ?>
                    <div class="item mb-20 wow fadeInUp" data-wow-delay="<?php echo $item['item_delay']; ?>s">
                        <div class="title">
                            <h4 class=""><?php echo esc_html($item['item_title']); ?></h4>
                            <span class="ico"></span>
                        </div>
                        <div class="accordion-info">
                            <p><?php echo esc_html($item['item_content']); ?></p>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php
    }
}
