<?php
namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;

if (!defined('ABSPATH')) exit;

class Bayone_Blog_List extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'bayone-blog-blog-list';
    }

    public function get_title()
    {
        return __('Bayone Blog List', 'bayone_plg');
    }

    public function get_script_depends() {
        return ['lib-isotope.min','lib-animsition.min','lib-charming.min' ,'bayone-gallery','bayone-charming'];
    }

    public function get_style_depends() {
        return [ 'lib-animsition.min' , 'lib-base'];
    }


    public function get_icon()
    {
        return 'eicon-post-list';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Blog List Settings', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'blog_post',
            [
                'label' => __('Blog Post to show', 'bayone_plg'),
                'type' => Controls_Manager::NUMBER,
                'default' => '9',

            ]
        );

        $this->add_control(
            'category',
            [
                'label' => __('Category', 'bayone_plg'),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => $this->bayone_category_options(),
            ]
        );

        $this->add_control(
            'post_order',
            [
                'label' => __('Post Order', 'bayone_plg'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'DESC' => __('Descending', 'bayone_plg'),
                    'ASC' => __('Ascending', 'bayone_plg'),
                    'rand' => __('Random', 'bayone_plg'),
                ],
                'default' => 'DESC',
            ]
        );

        $this->add_control(
            'selected_tag',
            [
                'label' => __('Select Tag', 'bayone_plg'),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->get_tag_options(),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'blog_style',
            [
                'label' => __('Blog Style', 'bayone_plg'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style1' => __('style1', 'bayone_plg'),
                    'style2' => __('style2', 'bayone_plg'),
                    'style3' => __('style3', 'bayone_plg')
                ],
                'default' => 'style1',
            ]
        );

        $this->add_control(
            'read_more_btn',
            [
                'label' => __('Read More Button', 'bayone_plg'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'label_on' => __('Show', 'bayone_plg'),
                'label_off' => __('Hide', 'bayone_plg'),
                'return_value' => 'yes',
            ]
        );

        $this->add_control(
            'btn_link_1',
            [
                'label' => __('Button Link', 'bayone_plg'),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => '#',
                ],
                'condition' => ['read_more_btn' => 'yes'],
            ]
        );

        $this->add_control(
            'read_more_text',
            [
                'label' => __('Read More Button Text', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => 'Read More',
                'condition' => [
                    'read_more_btn' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'sec_heading',
            [
                'label' => __('Section Heading', 'bayone_plg'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'label_on' => __('Show', 'bayone_plg'),
                'label_off' => __('Hide', 'bayone_plg'),
                'return_value' => 'yes',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_heading',
            [
                'label' => __('Heading Tab', 'bayone_plg'),
                'condition' => ['sec_heading' => 'yes'],
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Title', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('- News', 'bayone_plg'),
                'condition' => ['blog_style' => 'style3'],
            ]
        );

        $this->add_control(
            'heading',
            [
                'label' => __('Heading', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Blog &', 'bayone_plg'),
                'condition' => ['blog_style' => 'style3'],
            ]
        );

        $this->add_control(
            'sub_heading',
            [
                'label' => __('Sub Heading', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Insights', 'bayone_plg'),
                'condition' => ['blog_style' => 'style3'],
            ]
        );

        $this->add_control(
            'btn_text',
            [
                'label' => __('Button Text', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => __('View All Posts ', 'bayone_plg'),
                'condition' => ['blog_style' => 'style3'],
            ]
        );

        $this->add_control(
            'btn_link',
            [
                'label' => __('Button Link', 'bayone_plg'),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => '#',
                ],
                'condition' => ['blog_style' => 'style3'],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__( 'Style Section', 'textdomain' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        //date style for style 1,2,3
        $this->add_control(
            'date_color',
            [
                'label' => __('Date Color', 'bayone_plg'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .bayone-blog-column .date' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'date_typography',
                'label' => __('Date Typography', 'bayone_plg'),
                'selector' => '{{WRAPPER}} .bayone-blog-column .date',
            ]
        );
        $this->add_control(
            'date_opacity',
            [
                'label' => __('Date Opacity', 'bayone_plg'),
                'type' => Controls_Manager::NUMBER,
                'default' => 1,
                'min' => 0,
                'max' => 1,
                'selectors' => [
                    '{{WRAPPER}} .bayone-blog-column .date' => 'opacity: {{VALUE}};',
                ],
            ]
        );
        // heading style for style 1,2
        $this->add_control(
            'heading_color',
            [
                'label' => __('Heading Color', 'bayone_plg'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .bayone-blog-column .style1 .item .cont h4 , .bayone-blog-column .style2 .item .cont h4' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'blog_style' => ['style1', 'style2'],
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'heading_typography',
                'label' => __('Heading Typography', 'bayone_plg'),
                'selector' => '{{WRAPPER}} .bayone-blog-column .style1 .item .cont h4 , .bayone-blog-column .style2 .item .cont h4',
                'condition' => [
                    'blog_style' => ['style1', 'style2'],
                ],
            ]
        );

        // category style for style1 , style2
//        .bayone-blog-column .style1 .item .cont ul li a
        $this->add_control(
            'category_color',
            [
                'label' => __('Category Color', 'bayone_plg'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .bayone-blog-column .style1 .item .cont ul li a,.bayone-blog-column .style2 .item .cont ul li a' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'blog_style' => ['style1', 'style2'],
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'category_typography',
                'label' => __('Category Typography', 'bayone_plg'),
                'selector' => '{{WRAPPER}} .bayone-blog-column .style1 .item .cont .sub-title ,.bayone-blog-column .style2 .item .cont .sub-title ',
                'condition' => [
                    'blog_style' => ['style1', 'style2'],
                ],
            ]
        );





        $this->end_controls_section();

    }
    protected function render() {
        $settings = $this->get_settings_for_display();
        $selected_tag = $settings['selected_tag'];
        $style = $settings['blog_style'];
        $query_args = array(
            'posts_per_page' => $settings['blog_post'],
            'post_type' => 'post',
            'order' => $settings['post_order'],
        );
        if($style=='style2' || $style=='style3'){
            $query_args['meta_query'] = array(
                array(
                    'key' => '_thumbnail_id',
                    'compare' => 'EXISTS',
                ),
            );
        }

        if (!empty($settings['category'])) {
            $query_args['cat'] = $settings['category'];
        }
        if (!empty($selected_tag)) {
            $query_args['tag__in'] = $selected_tag;
        }

        $query = new \WP_Query($query_args);
        ?>
        <div class="bayone-blog-column">
            <?php if($style=="style1") : ?>
            <div class="style1">
                <div class="bayone-gallery">
                    <div class="row">
                        <?php while ($query->have_posts()) : $query->the_post(); ?>
                            <div class="items col-lg-4 col-md-6">
                                <div class="item">
                                    <?php if (has_post_thumbnail()) : ?>
                                        <div class="img">
                                            <img src="<?php esc_url(the_post_thumbnail_url()); ?>" alt="">
                                            <span class="date"><strong><?= the_time('d') ?></strong> <?= the_time('F') ?></span>
                                        </div>
                                        <div class="cont">
                                            <div class="sub-title opacity-8"><?= the_category(); ?></div>
                                            <h4><?= get_the_title() ?></h4>
                                            <?php if ($settings['read_more_btn'] == 'yes') : ?>
                                                <a href="<?= get_the_permalink() ?>"
                                                   class="animsition-link more"><?= esc_html($settings['read_more_text']); ?></a>
                                            <?php endif; ?>
                                        </div>
                                    <?php else : ?>
                                        <div class="cont cont-link">
                                            <div class="info sub-title fz-12 mb-15 opacity-8">
                                                <div class="d-inline-block"><?= the_category(); ?></div>
                                                <span class="mr-5 ml-5 inline-block">/</span>
                                                <?php
                                                $day = get_the_time('d');
                                                $formatted_day = (strlen($day) == 2 && $day[0] == '0') ? substr($day, 1) : $day;
                                                ?>
                                                <span class="inline-block"><?= $formatted_day . ' ' . get_the_time('F') ?></span>
                                            </div>
                                            <h4><?= get_the_title() ?></h4>
                                            <?php if ($settings['read_more_btn'] == 'yes') : ?>
                                                <a href="<?= get_the_permalink() ?>"
                                                   class="animsition-link more"><?= esc_html($settings['read_more_text']); ?></a>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endwhile;
                        wp_reset_postdata(); ?>
                    </div>
                </div>
            </div >
            <?php elseif($style=='style2') : ?>
            <div class="style2 bg-gray text-dark">
                <div class="row">
                    <?php $iteration=0; while ($query->have_posts()) : $query->the_post(); ?>
                        <?php if (has_post_thumbnail()) : ?>
                            <?php
                            $iteration++;
                            $is_last = ($iteration === $query->post_count);
                            ?>
                            <div class="col-lg-6">
                            <div class="item<?= (!$is_last) ? ' md-mb50' :'' ?>">
                                <div class="row">
                                    <div class="col-md-5">
                                        <div class="img">
                                            <img src="<?php esc_url(the_post_thumbnail_url()); ?>" alt="">
                                            <span class="date"><strong><?= the_time('d') ?></strong> <?= the_time('F') ?></span>
                                        </div>
                                    </div>
                                    <div class="col-md-7 valign">
                                    <div class="cont">
                                        <div class="sub-title inline-block ls1 mb-15 opacity-8"><?= the_category(); ?></div>
                                        <h4><?= get_the_title() ?></h4>
                                        <div class="underline">
                                            <a href="<?= get_the_permalink() ?>"
                                               class="animsition-link more mt-20"><?= esc_html($settings['read_more_text']); ?></a>
                                        </div>
                                    </div>
                                </div>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                    <?php endwhile; wp_reset_postdata(); ?>
                </div>
            </div>
            <?php else : ?>
                <section class="style3 bg-gray text-dark">
                    <div class="container">
                        <div class="sec-head mb-80">
                            <div class="d-flex align-items-center justify-end">
                                <div>
                                    <span class="sub-title mb-15 opacity-8"><?=$settings['title']?></span>
                                    <h3 class="text-u f-bold fz-50"><?=$settings['heading']?> <span class="f-ultra-light"><?=$settings['sub_heading']?></span></h3>
                                </div>
                                <div class="ms-auto underline">
                                    <a href="<?= $settings['btn_link']['url'] ?>" class="animsition-link all-more sub-title ls1">
                                        <span><?=$settings['btn_text']?> <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                        d="M13.922 4.5V11.8125C13.922 11.9244 13.8776 12.0317 13.7985 12.1108C13.7193 12.1899 13.612 12.2344 13.5002 12.2344C13.3883 12.2344 13.281 12.1899 13.2018 12.1108C13.1227 12.0317 13.0783 11.9244 13.0783 11.8125V5.51953L4.79547 13.7953C4.71715 13.8736 4.61092 13.9176 4.50015 13.9176C4.38939 13.9176 4.28316 13.8736 4.20484 13.7953C4.12652 13.717 4.08252 13.6108 4.08252 13.5C4.08252 13.3892 4.12652 13.283 4.20484 13.2047L12.4806 4.92188H6.18765C6.07577 4.92188 5.96846 4.87743 5.88934 4.79831C5.81023 4.71919 5.76578 4.61189 5.76578 4.5C5.76578 4.38811 5.81023 4.28081 5.88934 4.20169C5.96846 4.12257 6.07577 4.07813 6.18765 4.07812H13.5002C13.612 4.07813 13.7193 4.12257 13.7985 4.20169C13.8776 4.28081 13.922 4.38811 13.922 4.5Z"
                                                        fill="currentColor"></path>
                                            </svg>
                                        </span>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <?php $itemCount=.2; while ($query->have_posts()) : $query->the_post(); if (has_post_thumbnail()) : ?>
                            <div class="item block wow fadeInUp" data-wow-delay="<?php echo $itemCount ; $itemCount+=.2?>" data-fx="3">
                            <a href="<?= get_the_permalink() ?>" class="block__link animsition-link"
                               data-img="<?php esc_url(the_post_thumbnail_url()); ?>"></a>
                            <div class="row">
                                <div class="col-lg-6 cont">
                                    <div class="info">
                                        <div class="tag"><?= the_category(); ?></div>
                                        <span class="date"><?php echo get_the_date('F j, Y'); ?></span>
                                    </div>
                                    <h3 class="text-u"><?= get_the_title() ?></h3>
                                </div>
                                <div class="col-lg-3 offset-lg-3 d-flex align-items-center justify-end">
                                    <div class="ms-auto">
                                        <a href="<?= get_the_permalink() ?>" class="more mt-15 animsition-link">
                                                    <span><?=$settings['read_more_text']?>
                                                        <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <path d="M13.922 4.5V11.8125C13.922 11.9244 13.8776 12.0317 13.7985 12.1108C13.7193 12.1899 13.612 12.2344 13.5002 12.2344C13.3883 12.2344 13.281 12.1899 13.2018 12.1108C13.1227 12.0317 13.0783 11.9244 13.0783 11.8125V5.51953L4.79547 13.7953C4.71715 13.8736 4.61092 13.9176 4.50015 13.9176C4.38939 13.9176 4.28316 13.8736 4.20484 13.7953C4.12652 13.717 4.08252 13.6108 4.08252 13.5C4.08252 13.3892 4.12652 13.283 4.20484 13.2047L12.4806 4.92188H6.18765C6.07577 4.92188 5.96846 4.87743 5.88934 4.79831C5.81023 4.71919 5.76578 4.61189 5.76578 4.5C5.76578 4.38811 5.81023 4.28081 5.88934 4.20169C5.96846 4.12257 6.07577 4.07813 6.18765 4.07812H13.5002C13.612 4.07813 13.7193 4.12257 13.7985 4.20169C13.8776 4.28081 13.922 4.38811 13.922 4.5Z" fill="currentColor"></path>
                                                        </svg>
                                                    </span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endif; endwhile; wp_reset_postdata(); ?>
                    </div>
                </section>
           <?php endif; ?>
        </div>

        <?php
    }



    private function bayone_category_options() {
        $categories = get_categories();
        $category_options = ['' => __('All Categories', 'bayone_plg')]; // all categories option

        foreach ($categories as $category) {
            $category_options[$category->term_id] = $category->name;
        }

        return $category_options;
    }
    private function get_tag_options() {
        $tags = get_tags();
        $tag_options = [];

        foreach ($tags as $tag) {
            $tag_options[$tag->term_id] = $tag->name;
        }

        return $tag_options;
    }
}


