<?php
namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;

if (!defined('ABSPATH')) exit;

class Bayone_Brands extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'bayone-brands';
    }

    public function get_title()
    {
        return __('Bayone Brands', 'bayone_plg');
    }

    public function get_icon()
    {
        return 'eicon-image-box';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Brands Settings', 'bayone_plg'),
            ]
        );

        $repeater = new \Elementor\Repeater();


        $repeater->add_control(
            'image',
            [
                'label' => __('Image', 'bayone_plg'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'brand_list',
            [
                'label' => __('Brand List', 'bayone_plg'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'image' => Utils::get_placeholder_image_src(),
                    ],
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="bayone-brands">
                <div class="row justify-content-center">
                    <div class="col-lg-11">
                        <div class="brand-items">
                            <div class="row">
                                <?php foreach ($settings['brand_list'] as $brand) : ?>
                                <div class="col-lg-3 col-md-4 col-6 item">
                                    <div class="img">
                                        <img src="<?= $brand['image']['url'] ?>" alt="">
                                    </div>
                                </div>
                            <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
        </div>
        <?php
    }
}
