<?php
namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Bayone_Call_Action_Slide extends Widget_Base
{
    public function get_name()
    {
        return 'bayone-call-call-action-slide-slide';
    }

    public function get_script_depends() {
        return [ 'lib-gsap.min','lib-ScrollSmoother.min','lib-ScrollTrigger.min','lib-animsition.min','bayone-call-action-slide' ];
    }

    public function get_title()
    {
        return __('Bayone Call Action Slide', 'bayone_plg');
    }

    public function get_icon()
    {
        return 'eicon-h-align-left';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Call Action Slide Section', 'bayone_plg'),
            ]
        );


        $this->add_control(
            'link',
            [
                'label' => __('Link', 'bayone_plg'),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => '#',
                ],
            ]
        );

        $this->add_control(
            'text',
            [
                'label' => __('Text', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Get In Touch', 'bayone_plg'),
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $text = $settings['text'];
        $link = $settings['link']['url'];
        ?>
        <section class="bayone-call-action-slide bord-thin-bottom">
            <div class="contact-container">
                <div class="marquee-head">
                    <div class="container-fluid rest">
                        <div class="row">
                            <div class="col-12">
                                <div class="main-marq">
                                    <div class="slide-har st1">
                                        <?php for ($boxIndex = 0; $boxIndex < 2; $boxIndex++) : ?>
                                            <div class="box non-strok">
                                                <?php for ($itemIndex = 0; $itemIndex < 5; $itemIndex++) : ?>
                                                    <div class="item">
                                                        <h2>
                                                            <a href="<?= $link ?>" class="animsition-link"><?= $text; ?></a>
                                                            <span>
                        <svg
                                width="18" height="18" viewBox="0 0 18 18"
                                fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path
                                    d="M13.922 4.5V11.8125C13.922 11.9244 13.8776 12.0317 13.7985 12.1108C13.7193 12.1899 13.612 12.2344 13.5002 12.2344C13.3883 12.2344 13.281 12.1899 13.2018 12.1108C13.1227 12.0317 13.0783 11.9244 13.0783 11.8125V5.51953L4.79547 13.7953C4.71715 13.8736 4.61092 13.9176 4.50015 13.9176C4.38939 13.9176 4.28316 13.8736 4.20484 13.7953C4.12652 13.717 4.08252 13.6108 4.08252 13.5C4.08252 13.3892 4.12652 13.283 4.20484 13.2047L12.4806 4.92188H6.18765C6.07577 4.92188 5.96846 4.87743 5.88934 4.79831C5.81023 4.71919 5.76578 4.61189 5.76578 4.5C5.76578 4.38811 5.81023 4.28081 5.88934 4.20169C5.96846 4.12257 6.07577 4.07813 6.18765 4.07812H13.5002C13.612 4.07813 13.7193 4.12257 13.7985 4.20169C13.8776 4.28081 13.922 4.38811 13.922 4.5Z"
                                    fill="currentColor"></path>
                        </svg>
                    </span>
                                                        </h2>
                                                    </div>
                                                <?php endfor; ?>
                                            </div>
                                        <?php endfor; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <?php
    }
}
