<?php
namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;

if (!defined('ABSPATH')) exit;

class Bayone_Card_Arrow extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'bayone-card-card-arrow-animate';
    }

    public function get_script_depends() {
        return ['bayone-card-arrow-animsition','lib-animsition.min'];
    }

    public function get_title()
    {
        return __('Bayone Card Arrow', 'bayone_plg');
    }

    public function get_icon()
    {
        return 'eicon-menu-card';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Card Settings', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'icon_image',
            [
                'label' => __('Icon Image', 'bayone_plg'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Title', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Digital Marketing', 'bayone_plg'),
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'description',
            [
                'label' => __('Description', 'bayone_plg'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('Brand identity design is the key to success whether you breathe rebranding.', 'bayone_plg'),
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'btn_text',
            [
                'label' => __('Button Text', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => __('Read More', 'bayone_plg'),
                'condition' => [
                    'show_arrow' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'btn_link',
            [
                'label' => __('Button Link', 'bayone_plg'),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => '#',
                ],
                'condition' => [
                    'show_arrow' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'show_arrow',
            [
                'label' => __('Show Arrow Button', 'bayone_plg'),
                'type' => Controls_Manager::SWITCHER,
                'default' => true,
            ]
        );

        $this->add_control(
            'show_numb',
            [
                'label' => __('Show Numb', 'bayone_plg'),
                'type' => Controls_Manager::SWITCHER,
                'default' => false,
            ]
        );

        $this->add_control(
            'numb_value',
            [
                'label' => __('Numb Value', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => '01',
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'show_numb' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();
//        style tab
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__( 'Style Section', 'textdomain' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'icon_size',
            [
                'label' => esc_html__( 'Icon size', 'nextech_plg' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .bayone-card-arrow .item img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'bayone_plg'),
                'selector' => '{{WRAPPER}} .bayone-card-arrow .item h5',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'description_typography',
                'label' => __('Description Typography', 'bayone_plg'),
                'selector' => '{{WRAPPER}} .bayone-card-arrow .item p',
            ]
        );
        $this->add_control(
            'item_padding',
            [
                'label' => __('Item Padding', 'bayone_plg'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .bayone-card-arrow .item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'selector' => '{{WRAPPER}} .bayone-card-arrow .item',
            ]
        );
        $this->end_controls_section();

    }
    protected function render() {
        $settings = $this->get_settings_for_display();
        $title = $settings['title'];
        $description = $settings['description'];
        $show_numb = $settings['show_numb'];
        $numb_value = $settings['numb_value'];
        $show_arrow = $settings['show_arrow'];
        ?>
        <div class="bayone-card-arrow">
            <div class="item">
                <?php if($show_numb)  : ?>
                    <span class="numb"><?=$numb_value?></span>
                <?php endif ?>
                <span class="mb-40">
                    <img src="<?=$settings['icon_image']['url']?>" alt="">
                </span>
                <h5 class="fz-22"><?=$title?></h5>
                <p><?= $description ?></p>
                <?php  if($show_arrow) : ?>
                    <a href="<?= $settings['btn_link']['url'] ?>" class="link-more animsition-link mt-50">
                        <span class="text"><?= $settings['btn_text']?></span>
                        <span class="arrow">
                            <svg width="18" height="18" viewBox="0 0 18 18" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <path d="M13.922 4.5V11.8125C13.922 11.9244 13.8776 12.0317 13.7985 12.1108C13.7193 12.1899 13.612 12.2344 13.5002 12.2344C13.3883 12.2344 13.281 12.1899 13.2018 12.1108C13.1227 12.0317 13.0783 11.9244 13.0783 11.8125V5.51953L4.79547 13.7953C4.71715 13.8736 4.61092 13.9176 4.50015 13.9176C4.38939 13.9176 4.28316 13.8736 4.20484 13.7953C4.12652 13.717 4.08252 13.6108 4.08252 13.5C4.08252 13.3892 4.12652 13.283 4.20484 13.2047L12.4806 4.92188H6.18765C6.07577 4.92188 5.96846 4.87743 5.88934 4.79831C5.81023 4.71919 5.76578 4.61189 5.76578 4.5C5.76578 4.38811 5.81023 4.28081 5.88934 4.20169C5.96846 4.12257 6.07577 4.07813 6.18765 4.07812H13.5002C13.612 4.07813 13.7193 4.12257 13.7985 4.20169C13.8776 4.28081 13.922 4.38811 13.922 4.5Z" fill="currentColor">
                                </path>
                            </svg>
                        </span>
                    </a>
                <?php endif;?>
            </div>
        </div>
        <?php
    }

}
