<?php
namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Bayone_Clients_Carso extends Widget_Base {
    public function get_name() {
        return 'bayone-clients-clients-carso';
    }

    public function get_title() {
        return __('Bayone Clients carso', 'bayone_plg');
    }

    public function get_script_depends() {
        return [ 'bayone-testimonials' ];
    }

    public function get_icon() {
        return 'eicon-slider-push';
    }

    public function get_categories() {
        return ['bayone-elements'];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Clients carso', 'bayone_plg'),
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'client_image',
            [
                'label' => __('Client Image', 'bayone_plg'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'client_url',
            [
                'label' => __('Client URL', 'bayone_plg'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'client_items',
            [
                'label' => __('Client Items', 'bayone_plg'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="bayone-clients-carso">
            <div class="row justify-content-center">
                    <div class="col-lg-11">
                        <div class="swiper5" data-carousel="swiper" data-items="5" data-loop="true"
                             data-space="40">
                            <div id="content-carousel-container-unq-clients" class="swiper-container"
                                 data-swiper="container">
                                <div class="swiper-wrapper">
                                    <?php foreach ($settings['client_items'] as $item) : ?>
                                        <div class="swiper-slide" style="width: 125px;">
                                            <div class="item">
                                                <div class="img icon-img-100">
                                                    <a href="<?=$item['client_url']['url']?>">
                                                        <img src="<?=$item['client_image']['url']?>" alt="">
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
        </div>
        <?php
    }
}
