<?php
namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Bayone_Clients_Marq extends Widget_Base {
    public function get_name() {
        return 'bayone-clients-clients-marq';
    }

    public function get_title() {
        return __('Bayone Clients Marq', 'bayone_plg');
    }

    public function get_icon() {
        return 'eicon-slider-push';
    }

    public function get_categories() {
        return ['bayone-elements'];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Clients Marq', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'sub_bg',
            [
                'label' => __('Sub BG Class', 'bayone_plg'),
                'type' => Controls_Manager::SWITCHER,
                'default' => true,
            ]
        );


        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'client_image',
            [
                'label' => __('Client Image', 'bayone_plg'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'client_url',
            [
                'label' => __('Client URL', 'bayone_plg'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'client_items',
            [
                'label' => __('Client Items', 'bayone_plg'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $sub_bg=$settings['sub_bg'];
        ?>
        <div <?php if($sub_bg) : ?>class="sub-bg" <?php endif ?>>
            <div class="bayone-clients-marq no-bord my-2">
                <div class="main-marq">
                <div class="slide-har st1">
                    <div class="box non-strok">
                            <?php foreach ($settings['client_items'] as $item) : ?>
                                <div class="item">
                                    <div class="img icon-img-100">
                                        <a href="<?php echo esc_url($item['client_url']['url']); ?>">
                                            <img src="<?php echo esc_url($item['client_image']['url']); ?>" alt="">
                                        </a>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                    </div>
                    <div class="box non-strok">
                            <?php foreach ($settings['client_items'] as $item) : ?>
                                <div class="item">
                                    <div class="img icon-img-100">
                                        <a href="<?php echo esc_url($item['client_url']['url']); ?>">
                                            <img src="<?php echo esc_url($item['client_image']['url']); ?>" alt="">
                                        </a>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                    </div>
                </div>
            </div>
            </div>
        </div>
        <?php
    }
}
