<?php

namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;

if (!defined('ABSPATH')) {
    exit;
}

class  Bayone_Comments_form extends Widget_Base {

    public function get_name() {
        return 'bayone-comments-comments-form';
    }

    public function get_title() {
        return __('Bayone Comments Form', 'bayone_plg');
    }

    public function get_icon() {
        return 'eicon-form-horizontal';
    }

    public function get_categories() {
        return ['bayone-elements'];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Content', 'custom-comments-form-widget'),
            ]
        );

        $this->add_control(
            'form_id',
            [
                'label' => __('Select Form', 'custom-comments-form-widget'),
                'type' => Controls_Manager::SELECT,
                'options' => $this->get_contact_form_options(),
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="bayone-comments-from">
            <?= do_shortcode('[contact-form-7 id="' . $settings['form_id']  .'"]');?>
        </div>
        <?php
    }

    private function get_contact_form_options() {
        $options = [];
        $contact_forms = get_posts('post_type="wpcf7_contact_form"&numberposts=-1');
        foreach ($contact_forms as $form) {
            $options[$form->ID] = $form->post_title;
        }
        return $options;
    }
}