<?php

namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;

if (!defined('ABSPATH')) {
    exit;
}

class  Bayone_contact_form extends Widget_Base {

    public function get_name() {
        return 'bayone-contact-contact-form';
    }

    public function get_title() {
        return __('Bayone contact Form', 'bayone_plg');
    }

    public function get_icon() {
        return 'eicon-form-horizontal';
    }

    public function get_categories() {
        return ['bayone-elements'];
    }

    public function get_script_depends() {
        return [ 'bayone-form-button','lib-parallax.min'];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Content', 'custom-contact-form-widget'),
            ]
        );

        $this->add_control(
            'form_id',
            [
                'label' => __('Select Form', 'custom-contact-form-widget'),
                'type' => Controls_Manager::SELECT,
                'options' => $this->get_contact_form_options(),
            ]
        );

        $this->add_control(
            'alignment',
            [
                'label' => __('Alignment', 'custom-contact-form-widget'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'default' => __('Default', 'custom-contact-form-widget'),
                    'center' => __('Center', 'custom-contact-form-widget'),
                ],
                'default' => 'default',
            ]
        );


        $this->add_control(
            'heading',
            [
                'label' => __('Show Heading', 'bayone_plg'),
                'type' => Controls_Manager::SWITCHER,
                'default' => false,
            ]
        );

        $this->add_control(
            'bold_heading_text',
            [
                'label' => __('Bold Title', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Get In', 'bayone_plg'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => ['heading' => 'yes'],
            ]
        );

        $this->add_control(
            'ultra_light_heading_text',
            [
                'label' => __('Ultra Light Title', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Touch', 'bayone_plg'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => ['heading' => 'yes'],
            ]
        );

        $this->add_control(
            'sub_title',
            [
                'label' => __('Sub Title', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('- Contact Us', 'bayone_plg'),
                'dynamic' => [
                    'active' => true,
                ],
                    'condition' => ['heading' => 'yes'],
            ]
        );
        $this->end_controls_section();
//        style tab

        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__( 'Style Section', 'textdomain' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'typography',
                'label' => __('Heading Typography', 'bayone_plg'),
                'selector' => '{{WRAPPER}} .bayone-contact-form h3',
            ]
        );

        $this->add_control(
            'heading_color',
            [
                'label' => __('Title Color', 'bayone_plg'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .bayone-contact-form h3' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'Sub Title Section',
            [
                'label' => __('Sub Title Tab', 'bayone_plg'),
                'condition' => ['heading' => 'yes'],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sub_title_typography',
                'label' => __('Sub Title Typography', 'bayone_plg'),
                'selector' => '{{WRAPPER}} .bayone-contact-form .sub-title',
            ]
        );

        $this->add_control(
            'sub_title_color',
            [
                'label' => __('Sub Title Color', 'bayone_plg'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .bayone-contact-form .sub-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'sub_title_opacity',
            [
                'label' => __('Sub Title Opacity', 'bayone_plg'),
                'type' => Controls_Manager::NUMBER,
                'default' => 1,
                'min' => 0,
                'max' => 1,
                'selector' => '{{WRAPPER}} .bayone-contact-form .sub-title',
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'Button Section',
            [
                'label' => __('Button Tab', 'bayone_plg'),
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'label' => __('Submit Button Typography', 'bayone_plg'),
                'selector' => '{{WRAPPER}} .bayone-contact-form input[type="submit"]',
            ]
        );

        $this->add_responsive_control(
            'button_width',
            [
                'label' => __('Button Width', 'bayone_plg'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'default' => [
                    'size' => 100,
                    'unit' => '%',
                ],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .bayone-contact-form input[type="submit"]' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_height',
            [
                'label' => __('Button Height', 'bayone_plg'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'default' => [
                    'size' => 40,
                    'unit' => 'px',
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .bayone-contact-form input[type="submit"]' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_margin',
            [
                'label' => __('Button Margin', 'bayone_plg'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .bayone-contact-form input[type="submit"]' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $alignment = $settings['alignment'];
        $show_heading = $settings['heading'];
        $bold_heading_text = $settings['bold_heading_text'];
        $ultra_light_heading_text = $settings['ultra_light_heading_text'];
        $sub_title = $settings['sub_title'];
        ?>
            <div class="bayone-contact-form">
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <?php if($show_heading) : ?>
                                <div class="sec-head mb-80">
                                    <span class="sub-title mb-15" style="opacity: <?=$settings['sub_title_opacity']?>;"><?=$sub_title?></span>
                                    <h3 class="text-u f-bold fz-50"><?=$bold_heading_text ?><span class="f-ultra-light"><?=$ultra_light_heading_text?></span>.</h3>
                                </div>
                        <?php endif; ?>
                        <?= do_shortcode('[contact-form-7 id="' . $settings['form_id']  .'"]');?>
                    </div>
                </div>
            </div>
        <?php
        if ($alignment === 'center') {
            ?>
            <script>
                document.getElementById('buttonDiv').classList.add('text-center');
            </script>
            <?php
        }
    }

    private function get_contact_form_options() {
        $options = [];
        $contact_forms = get_posts('post_type="wpcf7_contact_form"&numberposts=-1');
        foreach ($contact_forms as $form) {
            $options[$form->ID] = $form->post_title;
        }
        return $options;
    }
}