<?php
namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;

if (!defined('ABSPATH')) exit;

class Bayone_Contact_Info extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'bayone-contact-info';
    }

    public function get_title()
    {
        return __('Bayone Contact Info', 'bayone_plg');
    }

    public function get_icon()
    {
        return 'eicon-image-box';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Contact Info Settings', 'bayone_plg'),
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'sub_title',
            [
                'label' => __('Heading', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Email', 'bayone_plg'),
            ]
        );

        $repeater->add_control(
            'info',
            [
                'label' => __('Info', 'bayone_plg'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('example@gmail.com', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => __('Contact Info Items', 'bayone_plg'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__( 'Style Section', 'textdomain' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'heading_color',
            [
                'label' => __('Heading Color', 'bayone_plg'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .bayone-contact-info .sub-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'heading_opacity',
            [
                'label' => __('Heading Opacity', 'bayone_plg'),
                'type' => Controls_Manager::NUMBER,
                'default' => 1,
                'min' => 0,
                'max' => 1,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'heading_typography',
                'label' => __('Heading Typography', 'bayone_plg'),
                'selector' => '{{WRAPPER}} .bayone-contact-info .sub-title',
            ]
        );

        $this->add_control(
            'info_color',
            [
                'label' => __('Text Info Color', 'bayone_plg'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .bayone-contact-info h6' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'text_typography',
                'label' => __('Text Typography', 'bayone_plg'),
                'selector' => '{{WRAPPER}} .bayone-contact-info h6',
            ]
        );

        $this->add_responsive_control(
            'sub_title_margin',
            [
                'label' => __('Heading Margin', 'bayone_plg'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .bayone-contact-info .sub-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'heading_margin',
            [
                'label' => __('Info Margin', 'bayone_plg'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .bayone-contact-info h6' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $heading_opacity= $settings['heading_opacity'];
        $items = $settings['items'];
        ?>
        <div class="bayone-contact-info">
            <div class="row justify-content-center">
                <?php $itemCount=1; foreach ($items as $item) : ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="item text-center <?php if($itemCount==1) echo 'sm-mb50 md-mb50'; elseif($itemCount==2) echo 'sm-mb50';?>">
                            <span class="sub-title" style="opacity: <?=$heading_opacity?>"><?=$item['sub_title']?></span>
                            <h6><?=$item['info']?></h6>
                        </div>
                    </div>
                <?php if($itemCount == 3) { $itemCount = 0; } $itemCount++; endforeach; ?>
            </div>
        </div>
        <?php
    }
}
