<?php
namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;

if (!defined('ABSPATH')) exit;

class Bayone_Creative_Portfolio_Header extends Widget_Base
{
    public function get_name()
    {
        return 'bayone-creative-portfolio-header';
    }

    public function get_title()
    {
        return __('Bayone Creative Portfolio Header', 'bayone_plg');
    }

    public function get_icon()
    {
        return 'eicon-image-box';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Creative Portfolio Header Settings', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Separated Title', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('We Are Studio Agency', 'bayone_plg'),
            ]
        );


        $this->add_control(
            'image',
            [
                'label' => __('Image', 'bayone_plg'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'inner_image',
            [
                'label' => __('Inner Image', 'bayone_plg'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'description',
            [
                'label' => __('Description', 'bayone_plg'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('We are a strategic partner to our clients. We will help you to ideate, design and implement your product from conception to iterative development support, always taking the initiative and working proactively.', 'bayone_plg'),
                'rows' => 5,
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $image_url = $settings['image']['url'];
        $inner_image_url = $settings['inner_image']['url'];
        $description = $settings['description'];
        $title = $settings['title'];
        $title_words = explode(' ', $title);
        ?>
            <div class="bayone-creative-portfolio-header">
                <header class="crev-header2">
                    <div class="row">
                        <div class="col-lg-10 offset-lg-1 mb-50">
                            <div class="text d-flex f-bold">
                                <span><?=$title_words[0]?></span>
                                <div class="img">
                                    <img src="<?php echo $image_url; ?>" alt="">
                                </div>
                                <span><?=$title_words[1]?></span>
                            </div>
                        </div>
                        <div class="col-lg-5">
                            <div class="text f-ultra-light">
                                <span><?=$title_words[2]?></span>
                            </div>
                        </div>
                        <div class="col-lg-3">
                            <div class="img-long">
                                <div class="iner-img">
                                    <img src="<?php echo $inner_image_url; ?>" alt="">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <p><?=$description?></p>
                        </div>
                        <div class="col-lg-10 offset-lg-1">
                        <div class="text text-lg text-center mt-50 f-bold">
                            <span><?=$title_words[3]?></span>
                        </div>
                    </div>
                    </div>
                </header>
            </div>
        <?php
    }
}
