<?php
namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;

if (!defined('ABSPATH')) exit;

class Bayone_Custom_Icon_Box extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'bayone-custom-icon-box';
    }

    public function get_title()
    {
        return __('Bayone Custom Icon Box', 'bayone_plg');
    }

    public function get_icon()
    {
        return 'eicon-icon-box';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Blog Card Settings', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'icon_image',
            [
                'label' => __('Icon Image', 'bayone_plg'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Title', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Digital Marketing', 'bayone_plg'),
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->end_controls_section();


    }
    protected function render() {
        $settings = $this->get_settings_for_display();
        $image_url = $settings['icon_image']['url'];
        $title =  $settings['title']
        ?>
        <div class="bayone-custom-icon-box">
            <div class="col-12">
                <div class="cont text-center">
                    <h6 class="sub-title"><span class="me-2"><img
                                    src="<?php echo esc_url($image_url); ?>" alt="" style="width: 30px"></span> <?php echo esc_html($title); ?></h6>
                </div>
            </div>
        </div>
        <?php
    }
}
