<?php

namespace bayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;

if (!defined('ABSPATH')) exit;

class Bayone_Demos_Gallery extends Widget_Base
{
    public function get_name()
    {
        return 'bayone-demos-gallery';
    }

    public function get_title()
    {
        return __('Bayone Demos Gallery', 'bayone_plg');
    }

    public function get_icon()
    {
        return 'eicon-gallery-masonry';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    public function get_script_depends()
    {
        return ['lib-wow.min', 'lib-isotope.min', 'bayone-demos-gallery'];
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Demos Gallery', 'bayone_plg'),
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'demo_title',
            [
                'label' => esc_html__('Demo Title', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'ai' => [
                    'type' => 'text',
                ],
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__('Enter your title', 'bayone_plg'),
                'default' => esc_html__('Add Text Here', 'bayone_plg'),
            ]
        );
        $repeater->add_control(
            'demo_image',
            [
                'label' => __('Demo Image', 'bayone_plg'),
                'type' => Controls_Manager::MEDIA,
            ]
        );
        $repeater->add_control(
            'demo_link',
            [
                'label' => __('Demo Link', 'bayone_plg'),
                'type' => Controls_Manager::URL,
            ]
        );
        $repeater->add_control(
            'anim_delay',
            [
                'label' => esc_html__('Animation Delay', 'bayone_plg'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 1,
                        'min' => 0.1,
                        'step' => 0.01,
                    ],
                ],
            ]
        );

        $this->add_control(
            'demos',
            [
                'label' => __('Demos', 'bayone_plg'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ demo_title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'text_style',
            [
                'label' => esc_html('Text Style', 'bayone_plg'),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Title Typography', 'bayone_plg'),
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .bayone-demos .item .title',
            ]
        );
        $this->add_control(
            'text_color',
            [
                'label' => esc_html__( 'Text Color', 'bayone_plg' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bayone-demos .item .title' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>
        <div class="bayone-demos">
            <div class="row">
                <?php foreach ($settings['demos'] as $demo) : ?>
                    <div class="col-lg-4 col-md-6 items">
                        <div class="item text-center wow fadeInUp">
                            <a href="<?= esc_url($demo['demo_link']['url']) ?>" <?php if ($demo['demo_link']['is_external']) echo 'target="_blank"'; ?>>
                                <div class="img">
                                    <img src="<?= esc_url($demo['demo_image']['url']) ?>" alt="<?php if (!empty($demo['demo_image']['alt'])) echo esc_attr($demo['demo_image']['alt']); ?>">
                                </div>
                                <h6 class="title"><?= $demo['demo_title'] ?></h6>
                            </a>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
<?php
    }
}
