<?php
namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;

if (!defined('ABSPATH')) exit;

class Bayone_Exp_Circle extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'bayone-exp-exp-circle';
    }

    public function get_title()
    {
        return __('Bayone Circle With Text', 'bayone_plg');
    }

    public function get_icon()
    {
        return 'eicon-button';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Circle Text Settings', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Title', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('12+', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'sub_title',
            [
                'label' => __('Sub Title', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Years of Experience', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'alignment',
            [
                'label' => __('Alignment', 'bayone_plg'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'start' => [
                        'title' => __('Start', 'bayone_plg'),
                        'icon' => 'eicon-h-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'bayone_plg'),
                        'icon' => 'eicon-h-align-center',
                    ],
                    'end' => [
                        'title' => __('End', 'bayone_plg'),
                        'icon' => 'eicon-h-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
            ]
        );


        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $title = $settings['title'];
        $sub_title = $settings['sub_title'];
        $alignment = $settings['alignment'];
        $alignment_classes = '';
        if ($alignment) {
            $alignment_classes = 'justify-content-'.$alignment;
        }
        ?>
        <div class="bayone-exp-circle d-flex align-items-center justify-content-center">
            <div class="exp valign text-center ">
                <div class="full-width">
                    <h2><?=$title?></h2>
                    <h6 class="sub-title"><?=$sub_title?></h6>
                </div>
            </div>
        </div>
        <?php
    }
}
