<?php
namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;

if (!defined('ABSPATH')) exit;

class Bayone_Fixed_Scroll_Images extends Widget_Base
{
    public function get_name()
    {
        return 'bayone-fixed-scroll-images';
    }

    public function get_script_depends() {
        return [ 'lib-gsap.min', 'lib-ScrollTrigger.min', 'bayone-hscroll' ];
    }

    public function get_title()
    {
        return __('Bayone Fixed Scroll Images', 'bayone_plg');
    }


    public function get_icon()
    {
        return 'eicon-slider';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Work Scroll', 'bayone_plg'),
            ]
        );

        $repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'image',
			[
				'label' => esc_html__( 'Choose Image', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'images_list',
			[
				'label' => esc_html__( 'Repeater List', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'image' => esc_html__( 'Title #1', 'textdomain' ),
					],
				],
			]
		);

        $this->end_controls_section();
        
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        
        ?>
        <div class="bayone-fixed-scroll-images thecontainer ontop">
            <?php foreach($settings['images_list'] as $item): ?>
                <div class="panel">
                    <div class="item">
                        <div class="img">
                            <img src="<?= esc_url($item['image']['url']); ?>" alt="">
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        <?php
    }

}
