<?php
namespace bayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;

if (!defined('ABSPATH')) exit;

class bayone_Header extends Widget_Base
{
    public function get_name()
    {
        return 'bayone-header';
    }

    public function get_title()
    {
        return __('bayone Header', 'bayone_plg');
    }

    public function get_icon()
    {
        return 'eicon-slider-album';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }
    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Header', 'bayone_plg'),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'bayone_plg' ),
                'type' => Controls_Manager::TEXT,
                'ai' => [
                    'type' => 'text',
                ],
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'Enter your title', 'bayone_plg' ),
                'default' => esc_html__( 'bayone', 'bayone_plg' ),
            ]
        );
        $this->add_control(
            'text',
            [
                'label' => esc_html__( 'Text', 'bayone_plg' ),
                'type' => Controls_Manager::TEXTAREA,
                'ai' => [
                    'type' => 'text',
                ],
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__( 'Enter your text', 'bayone_plg' ),
                'default' => esc_html__( 'A PERFECT PLACE FOR YOUR CREATIVE PORTFOLIO.', 'bayone_plg' ),
            ]
        );
        $this->add_control(
            'left_images',
            [
                'label' => __('Left Images', 'bayone_plg'),
                'type' => Controls_Manager::GALLERY,
                'default' => [],
            ]
        );

        $this->add_control(
            'right_images',
            [
                'label' => __('Right Images', 'bayone_plg'),
                'type' => Controls_Manager::GALLERY,
                'default' => [],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'text_style',
            [
                'label' => esc_html('Text Style', 'bayone_plg'),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Title Typography', 'bayone_plg'),
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .bayone-header .cont .caption .title',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Sub Title Typography', 'bayone_plg'),
                'name' => 'sub_title_typography',
                'selector' => '{{WRAPPER}} .bayone-header .cont .caption .sub-title',
            ]
        );
        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
            <div class="bayone-header">
                <div class="cont">
                    <div class="caption">
                        <div class="text-center">
                            <h1 class="title"><?=esc_html($settings['title'])?></h1>
                            <h5 class="sub-title"><?=esc_html($settings['text'])?></h5>
                        </div>
                    </div>
                    <div class="img-marq">
                        <div class="shadow-left box-shadow"></div>
                        <div class="shadow-right box-shadow"></div>
                        <div class="slide-img-left">
                            <?php for ($i=0;$i<2;$i++) : ?>
                                    <div class="box">
                                        <?php foreach ($settings['left_images'] as $image) : ?>
                                            <img src="<?= esc_url($image['url']); ?>" alt="<?php if (!empty($image['alt'])) echo esc_attr($image['alt']); ?>">
                                        <?php endforeach; ?>
                                    </div>
                            <?php endfor;?>
                        </div>
                        <div class="slide-img-right">
                            <?php for ($i=0;$i<2;$i++) : ?>
                                    <div class="box">
                                        <?php foreach ($settings['right_images'] as $image) : ?>
                                            <img src="<?= esc_url($image['url']); ?>" alt="<?php if (!empty($image['alt'])) echo esc_attr($image['alt']); ?>">
                                        <?php endforeach; ?>
                                    </div>
                            <?php endfor;?>
                        </div>
                    </div>
                </div>
            </div>
        <?php
    }
}