<?php

namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * @since 1.0.0
 */
class Bayone_home_slider extends Widget_Base
{

    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'bayone-home-home-slider';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('Bayone Home Slider', 'bayone_plg');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'eicon-slider-push';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['bayone-elements'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Slider Settings', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Title', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Bayone', 'bayone_plg'),
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'sub_title',
            [
                'label' => __('Sub Title', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('A PERFECT PLACE FOR YOUR CREATIVE PORTFOLIO.', 'bayone_plg'),
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        // Add the images repeater control
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'image',
            [
                'label' => __('Image', 'bayone_plg'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'images_list_left',
            [
                'label' => __('Images List for Left Slider', 'bayone_plg'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'image' => \Elementor\Utils::get_placeholder_image_src(),
                    ],
                ],
                'title_field' => '{{{ image.url }}}',
            ]
        );

        $this->add_control(
            'images_list_right',
            [
                'label' => __('Images List for Right Slider', 'bayone_plg'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'image' => \Elementor\Utils::get_placeholder_image_src(),
                    ],
                ],
                'title_field' => '{{{ image.url }}}',
            ]
        );

        $this->end_controls_section();
    }

    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $images_list_right = $settings['images_list_right'];
        $images_list_left = $settings['images_list_left'];
        $title=$settings['title'];
        $sub_title=$settings['sub_title']
        ?>
        <div class="bayone-home-slider">
            <div class="caption">
                <div class="text-center">
                    <h1><?=$title?></h1>
                    <h5 class="f-ultra-light"><?=$sub_title?></h5>
                </div>
            </div>
            <div class="img-marq">
                <div class="circle-shadow"></div>
                <div class="shadow-left box-shadow"></div>
                <div class="shadow-right box-shadow"></div>
                <div class="slide-img-left">
                    <div class="box">
                    <?php foreach ($images_list_left as $item) : ?>
                            <img src="<?php echo $item['image']['url']; ?>" alt="">
                    <?php endforeach; ?>
                    </div>
                </div>
                <div class="slide-img-right">
                    <div class="box">
                    <?php foreach ($images_list_right as $item) : ?>
                            <img src="<?php echo $item['image']['url']; ?>" alt="">
                    <?php endforeach; ?>
                    </div>
                </div>
                </div>
        </div>
        <?php
    }

}
