<?php
namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;

if (!defined('ABSPATH')) exit;

class Bayone_Image_With_Text extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'bayone-image-with-text-animate';
    }

    public function get_title()
    {
        return __('Bayone Image Text', 'bayone_plg');
    }

    public function get_icon()
    {
        return 'eicon-image-box';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Image Text Settings', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => __('Image', 'bayone_plg'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'job_title',
            [
                'label' => __('Job Title', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Web Designer', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'person_name',
            [
                'label' => __('Person\'s Name', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Leonardo DiCaprio', 'bayone_plg'),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__( 'Style Section', 'textdomain' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'job_title_typography',
                'label' => __('Job Title Typography', 'bayone_plg'),
                'selector' => '{{WRAPPER}} .bayone-image-with-text .info span',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'person_name_typography',
                'label' => __('Person Name Typography', 'bayone_plg'),
                'selector' => '{{WRAPPER}} .bayone-image-with-text .info .name',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $image_url = $settings['image']['url'];
        $job_title = $settings['job_title'];
        $person_name = $settings['person_name'];
        ?>
        <div class="bayone-image-with-text">
            <div class="rest">
                <div class="no-pad">
                    <div class="item ">
                        <div class="img">
                            <img src="<?php echo $image_url; ?>" alt="">
                        </div>
                        <div class="info mt-20">
                            <span ><?php echo $job_title; ?></span>
                            <p class="name"><?php echo $person_name; ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}
