<?php
namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;

if (!defined('ABSPATH')) exit;

class Bayone_Images_Carousel extends Widget_Base
{
    public function get_name()
    {
        return 'bayone-images-carousel';
    }

    public function get_script_depends() {
        return [ 'lib-gsap.min', 'lib-ScrollTrigger.min', 'bayone-hscroll' ];
    }

    public function get_title()
    {
        return __('Bayone Images Carousel', 'bayone_plg');
    }


    public function get_icon()
    {
        return 'eicon-slider';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Images Slider', 'bayone_plg'),
            ]
        );

        $repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'image',
			[
				'label' => esc_html__( 'Choose Image', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'images_list',
			[
				'label' => esc_html__( 'Repeater List', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'image' => esc_html__( 'Title #1', 'textdomain' ),
					],
				],
			]
		);

        $this->end_controls_section();
        
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__( 'Style Section', 'textdomain' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_responsive_control(
			'image_height',
			[
				'label' => esc_html__('Image Height', 'bayone_plg'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'vh', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .bayone-images-carousel .img' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'image_min_height',
			[
				'label' => esc_html__('Image Min Height', 'bayone_plg'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'vh', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .bayone-images-carousel .img' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();
        
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        
        ?>
        <div class="bayone-images-carousel">
            <div class="project2" data-carousel="swiper" data-items="2" data-loop="true" data-space="30" data-center="true">
                <div id="content-carousel-container-unq-project2" class="swiper-container" data-swiper="container">
                    <div class="swiper-wrapper">
                        <?php foreach($settings['images_list'] as $item): ?>
                            <div class="swiper-slide">
                                <div class="img">
                                    <img src="<?= esc_url($item['image']['url']); ?>" alt="">
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }

}
