<?php
namespace bayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class bayone_images_Marquee extends Widget_Base
{
    public function get_name()
    {
        return 'bayone-images-marquee';
    }

    public function get_title()
    {
        return __('bayone Images Marquee', 'bayone_plg');
    }

    public function get_icon()
    {
        return 'eicon-h-align-left';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Images Marquee Section', 'bayone_plg'),
            ]
        );
        $this->add_control(
            'images',
            [
                'label' => __('Images', 'bayone_plg'),
                'type' => Controls_Manager::GALLERY,
                'default' => [],
            ]
        );
        $this->add_control(
            'slide_option',
            [
                'label' => __('Slide Option', 'bayone_plg'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'slide_right' => __('Slide Right', 'bayone_plg'),
                    'slide_left' => __('Slide Left', 'bayone_plg'),
                ],
                'default' => 'slide_right',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $images = $settings['images'];
        $slide_option = $settings['slide_option'];
        ?>
        <div class="bayone-images-marquee">
            <div class="slide-har <?php if($slide_option=='slide_right')echo 'st1';elseif ($slide_option=='slide_left')echo 'st2';?>">
                <?php for($i=1;$i<3;$i++) :?>
                    <div class="box">
                        <?php foreach ($images as $item) :?>
                            <div class="item">
                                <img src="<?=esc_url($item['url'])?>" alt="<?php if (!empty($item['alt'])) echo esc_attr($item['alt']); ?>">
                            </div>
                        <?php endforeach;?>
                    </div>
                <?php endfor;?>
            </div>
        </div>
        <?php
    }
}
