<?php
namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Bayone_Interactive_Portfolio extends Widget_Base
{
    public function get_name()
    {
        return 'bayone-interactive-portfolio';
    }

    public function get_script_depends() {
        return ['lib-charming.min', 'lib-gsap.min' ,'bayone-inter-links-center' , 'bayone-charming'];
    }

    public function get_title()
    {
        return __('Bayone Interactive Portfolio', 'bayone_plg');
    }

    public function get_icon()
    {
        return 'eicon-gallery-masonry';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Work Gallery', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'text',
            [
                'label' => __('Text', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Selected Projects', 'bayone_plg'),
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'portfolio_item',
            [
                'label' => __( 'Item to display', 'bayone_blg' ),
                'type' => Controls_Manager::NUMBER,
                'default' => '8',
            ]
        );

        $this->add_control(
            'port_order',
            [
                'label' => __( 'Orders', 'bayone_blg' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'DESC' => __( 'Descending', 'bayone_blg' ),
                    'ASC' => __( 'Ascending', 'bayone_blg' ),
                    'rand' => __( 'Random', 'bayone_blg' ),
                ],
                'default' => 'DESC',
            ]
        );

        $this->add_control(
            'selected_terms',
            [
                'label' => __('Select Taxonomy Terms', 'bayone_plg'),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->get_taxonomy_terms(),
                'default' => [],
            ]
        );

        $this->add_control(
            'selected_tags',
            [
                'label' => __('Select Tags', 'bayone_plg'),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->get_tag_options(),
                'default' => [],
            ]
        );

        $this->add_control(
            'interactive_style',
            [
                'label' => __('Interactive Portfolio Style', 'bayone_plg'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'interactive_full' => __('Full', 'bayone_plg'),
                    'interactive_center' => __('Center', 'bayone_plg'),
                    'interactive_vertical' => __('Vertical', 'bayone_plg'),
                    'interactive_inline' => __('Inline', 'bayone_plg'),
                ],
                'default' => 'interactive_full',
            ]
        );


        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $interactive_style = $settings['interactive_style'];
        $selected_terms = $settings['selected_terms'];
        $selected_tags = $settings['selected_tags'];
        $text = $settings['text'];
        if ($settings['port_order'] != 'rand') {
            $order = 'order';
            $ord_val = $settings['port_order'];
        } else {
            $order = 'orderby';
            $ord_val = 'rand';
        }
        $bayone_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
        $query_args = array(
            'paged' => $bayone_paged,
            'posts_per_page' => $settings['portfolio_item'],
            'post_type' => 'portfolio',
            $order => $ord_val,
        );
        if (!empty($selected_terms)) {
            $query_args['tax_query'] = array(
                array(
                    'taxonomy' => 'portfolio_category',
                    'field' => 'term_id',
                    'terms' => $selected_terms,
                ),
            );
        }
        if (!empty($selected_tags)) {
            $query_args['tax_query'][] = array(
                'taxonomy' => 'porto_tag',
                'field' => 'term_id',
                'terms' => $selected_tags,
            );
        }
        $bayone_work = new \WP_Query($query_args);
        ?>
            <div class="bayone-interactive-portfolio">
                <?php if($interactive_style=='interactive_full' || $interactive_style=='interactive_vertical') : ?>
                    <div class="inter-links-center <?= ($interactive_style=='interactive_vertical') ? "vertical d-flex align-items-end pb-80" : "" ?> section-padding">
                        <div class="row">
                            <div class="col-12 d-flex align-items-center <?= ($interactive_style=='interactive_vertical') ? "justify-content-center" : "" ?> ">
                                <div class="links-text">
                                    <ul class="rest">
                                        <?php $itemCount=1; if ($bayone_work->have_posts()) : while  ($bayone_work->have_posts()) : $bayone_work->the_post(); global $post ; ?>
                                            <li data-tab="tab-<?=$itemCount?>">
                                            <h2 <?= ($interactive_style=='interactive_full') ? "class='fz-80'" : "" ?>>
                                                <span class="num"><?= ($itemCount < 10 ? '0' : '') . $itemCount ?>. </span>
                                                <a href="<?= get_the_permalink() ?>" class="animsition-link"><span class="text f-bold"><?= get_the_title() ?></span> </a>
                                            </h2>
                                        </li>
                                         <?php $itemCount++;  endwhile;  wp_reset_postdata(); endif; ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    <div class="links-img">
                        <?php $itemCount=1; if ($bayone_work->have_posts()) : while  ($bayone_work->have_posts()) : $bayone_work->the_post(); global $post ; ?>
                            <div class="img" id="tab-<?=$itemCount?>" data-overlay-dark="3">
                                <img src="<?= esc_url(get_the_post_thumbnail_url()); ?>" alt="">
                            </div>
                        <?php $itemCount++;  endwhile;  wp_reset_postdata(); endif; ?>
                    </div>
                </div>
                <?php elseif($interactive_style=='interactive_center') : ?>
                    <div class="interactive-center">
                        <div class="text-center">
                             <?php if ($bayone_work->have_posts()) : while  ($bayone_work->have_posts()) : $bayone_work->the_post(); global $post ; ?>
                                <div class="item block" data-fx="1">
                                    <a href="<?= get_the_permalink() ?>" class="block__link animsition-link" data-img="<?= esc_url(get_the_post_thumbnail_url()); ?>">
                                        <div class="cont">
                                            <h4 class="f-bold"><?= get_the_title() ?></h4>
                                            <?php
                                            $bayone_work_taxonomy = 'portfolio_category';
                                            $bayone_work_taxs = wp_get_post_terms($post->ID, $bayone_work_taxonomy);
                                            ?>
                                            <?php foreach ($bayone_work_taxs as $bayone_work_tax) : ?>
                                                <p><?= $bayone_work_tax->name ?></p>
                                            <?php endforeach; ?>
                                        </div>
                                    </a>
                                </div>
                             <?php endwhile;  wp_reset_postdata(); endif; ?>

                        </div>
                    </div>
                <?php elseif ($interactive_style=='interactive_inline') : ?>
                        <div class="interactive-inline d-flex align-items-end flex-wrap">
                        <?php $itemCount=1; if ($bayone_work->have_posts()) : while  ($bayone_work->have_posts()) : $bayone_work->the_post(); global $post ; ?>
                            <div class="item block" data-fx="1">
                                <a href="<?= get_the_permalink() ?>" class="block__link animsition-link" data-img="<?= esc_url(get_the_post_thumbnail_url()); ?>"></a>
                                <div class="cont">
                                    <span class="mb-10 text-u"><?= ($itemCount < 10 ? '0' : '') . $itemCount ?><span class="ml-10 mr-10">/</span>
                                        <?php
                                        $bayone_work_taxonomy = 'portfolio_category';
                                        $bayone_work_taxs = wp_get_post_terms($post->ID, $bayone_work_taxonomy);
                                        ?>
                                        <?php foreach ($bayone_work_taxs as $bayone_work_tax) : ?>
                                            <?= $bayone_work_tax->name ?>
                                        <?php endforeach; ?>
                                    </span>
                                    <h4 class="f-bold"><?= get_the_title() ?></h4>
                                </div>
                            </div>
                        <?php $itemCount++;  endwhile;  wp_reset_postdata(); endif; ?>
                        </div>
                <?php endif; ?>
            </div>
        <?php
    }



    private function get_taxonomy_terms() {
        $terms = get_terms(array(
            'taxonomy' => 'portfolio_category',
            'hide_empty' => true,
        ));

        $options = [];
        foreach ($terms as $term) {
            $options[$term->term_id] = $term->name;
        }

        return $options;
    }
    private function get_tag_options() {
        $tags = get_terms(array(
            'taxonomy' => 'porto_tag',
            'hide_empty' => true,
        ));

        $options = [];
        foreach ($tags as $tag) {
            $options[$tag->term_id] = $tag->name;
        }

        return $options;
    }


}
