<?php
namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;

if (!defined('ABSPATH')) exit;

class Bayone_List_Rest extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'bayone-list-rest';
    }

    public function get_title()
    {
        return __('Bayone List Rest', 'bayone_plg');
    }

    public function get_icon()
    {
        return 'eicon-editor-list-ul';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('List Rest Settings', 'bayone_plg'),
            ]
        );
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'icon',
            [
                'label' => __('Icon', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('+', 'bayone_plg'),
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $repeater->add_control(
            'title',
            [
                'label' => __('Title', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Branding Strategy', 'bayone_plg'),
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'list_items',
            [
                'label' => __('List Items', 'bayone_plg'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'icon' => '+',
                        'title' => 'Branding Strategy',
                    ],
                ],
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->end_controls_section();


    }
    protected function render() {
        $settings = $this->get_settings_for_display();
        $icon = $settings['icon'];
        $title =  $settings['title']
        ?>
        <div class="bayone-list-rest">
            <div class="sm-mb30">
                <ul class="list rest">
                    <?php foreach ($settings['list_items'] as $item) : ?>
                        <li class="fz-18 mb-15"><span class="mr-10"><?=$item['icon']?></span><?=$item['title']?></li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>
        <?php
    }
}
