<?php
namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Bayone_Marquee_Section extends Widget_Base
{
    public function get_name()
    {
        return 'bayone-marquee-marquee-section';
    }

    public function get_title()
    {
        return __('Bayone Marquee Section', 'bayone_plg');
    }

    public function get_script_depends() {
        return ['lib-gsap.min','lib-ScrollSmoother.min','lib-ScrollTrigger.min'];
    }

    public function get_icon()
    {
        return 'eicon-h-align-left';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Marquee Section', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => __('Marquee Items', 'bayone_plg'),
                'type' => Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'title',
                        'label' => __('Title', 'bayone_plg'),
                        'type' => Controls_Manager::TEXT,
                        'default' => __('UI-UX Experience', 'bayone_plg'),
                        'label_block' => true,
                    ],
                ],
                'default' => [
                    [
                        'title' => __('UI-UX Experience', 'bayone_plg'),
                    ],
                    [
                        'title' => __('Web Development', 'bayone_plg'),
                    ],
                    [
                        'title' => __('Digital Marketing', 'bayone_plg'),
                    ],
                ],
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->add_control(
            'style_option',
            [
                'label' => __('Style Option', 'bayone_plg'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'lrg' => __('Large', 'bayone_plg'),
                    'xlrg' => __('Extra Large', 'bayone_plg'),
                    'xlg-pading' => __('Extra Large Padding', 'bayone_plg'),
                    '' => __('None','bayone_plg')
                ],
                'default' => '',
            ]
        );

        $this->add_control(
            'stroke_option',
            [
                'label' => __('Stroke Option', 'bayone_plg'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'strok' => __('Stroke Text', 'bayone_plg'),
                    'non-strok' => __('Non Stroke', 'bayone_plg'),
                ],
                'default' => 'strok',
            ]
        );

        $this->add_control(
            'margin',
            [
                'label' => __('Margin Value', 'bayone_plg'),
                'type' => Controls_Manager::DIMENSIONS,
                'description' => __('Set the margin for the marquee section.', 'bayone_plg'),
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .bayone-marquee-section .marquee' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $items = $settings['items'];
        $stroke_option = $settings['stroke_option'];
        ?>
        <div class="bayone-marquee-section">
            <section class="marquee pt-50 pb-50 bord-thin-bottom bord-thin-top">
                <div class="rest">
                    <div class="main-marq <?php echo esc_attr($settings['style_option']); ?>">
                        <div class="slide-har st1">
                                <div class="box <?= ($stroke_option=='non-strok') ? "non-strok" : "" ?> ">
                                    <?php foreach ($items as $item) : ?>
                                    <div class="item">
                                        <h4 class="d-flex align-items-center f-bold">
                                            <span><?php echo esc_html($item['title']); ?></span>
                                            <span class="ml-50 stroke icon">*</span>
                                        </h4>
                                    </div>
                                    <?php endforeach; ?>

                                </div>
                                <div class="box <?= ($stroke_option=='non-strok') ? "non-strok" : "" ?>">
                                    <?php foreach ($items as $item) : ?>
                                    <div class="item">
                                        <h4 class="d-flex align-items-center f-bold">
                                            <span><?php echo esc_html($item['title']); ?></span>
                                            <span class="ml-50 stroke icon">*</span>
                                        </h4>
                                    </div>
                                    <?php endforeach; ?>
                                </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
        <?php
    }
}
