<?php
namespace bayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Icons_Manager;

if (!defined('ABSPATH')) exit;

class bayone_Matrix extends Widget_Base
{
    public function get_name()
    {
        return 'bayone-matrix';
    }

    public function get_title()
    {
        return __('bayone Matrix', 'bayone_plg');
    }

    public function get_icon()
    {
        return 'eicon-text-field';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Matrix Settings', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'speed',
            [
                'label' => __('Speed', 'bayone_plg'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'default' => 95,
            ]
        );
        $this->add_control(
            'speed_unit',
            [
                'label' => __('Speed Unit', 'bayone_plg'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('%', 'bayone_plg'),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __('Heading', 'bayone_plg'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Page Speed Score', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => esc_html__( 'Choose Image', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'text_style',
            [
                'label' => esc_html('Text Style', 'bayone_plg'),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Title Typography', 'bayone_plg'),
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .bayone-matrix .text h2',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Sub Title Typography', 'bayone_plg'),
                'name' => 'sub_title_typography',
                'selector' => '{{WRAPPER}} .bayone-matrix .text .sub-title',
            ]
        );
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
            <div class="bayone-matrix">
                <img src="<?=esc_url($settings['image']['url'])?>" alt="<?php if (!empty($settings['image']['alt'])) echo esc_attr($settings['image']['alt']); ?>">
                <div class="text">
                    <h2><?=esc_html($settings['speed'])?> <span><?=esc_html($settings['speed_unit'])?></span></h2>
                    <span class="sub-title"><?=esc_html($settings['title'])?></span>
                </div>
            </div>
        <?php
    }
}