<?php

namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Repeater;
use Elementor\Icons_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly



/**
 * @since 1.1.0
 */
class Bayone_Menu extends Widget_Base
{

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.1.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'bayone-menu';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.1.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return __('bayone Menu', 'bayone_plg');
	}

	//script depend
	public function get_script_depends()
	{
		return ['bayone-menu', 'lib-page-lines'];
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.1.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'fa fa-th-large';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.1.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories()
	{
		return ['bayone-menu-elements'];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.1.0
	 *
	 * @access protected
	 */
	protected function _register_controls()
	{

		$this->start_controls_section(
			'section_title',
			[
				'label' => __('Menu to Display', 'bayone_plg'),
			]
		);

		$menus = bayone_navmenu_navbar_menu_choices();
		if (!empty($menus)) {
			$this->add_control(
				'bayone_menu',
				[
					'label'   => __('Select Menu', 'bayone_plg'),
					'type'    => Controls_Manager::SELECT,
					'options' => $menus,
					'default' => array_keys($menus)[0],
				]
			);
		} else {
			$this->add_control(
				'menu',
				[
					'type' => Controls_Manager::RAW_HTML,
					'raw' => '<strong>' . __('There are no menus in your site.', 'bayone_plg') . '</strong><br>' . sprintf(__('Go to the <a href="%s" target="_blank">Menus screen</a> to create one.', 'bayone_plg'), admin_url('nav-menus.php?action=edit&menu=0')),
					'separator' => 'after',
					'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
				]
			);
		}

		$this->add_control(
			'menu_style',
			[
				'label' => __('Style', 'bayone_plg'),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'default' => __('Default', 'bayone_plg'),
					'animated-text' => __('Animated Text', 'bayone_plg'),
					'menu-list' => __('List', 'bayone_plg'),
				],
				'default' => 'default',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_main-menu',
			[
				'label' => __('Main Menu', 'bayone_plg'),
				'tab' => Controls_Manager::TAB_STYLE,

			]
		);

		$this->start_controls_tabs('tabs_menu_item_style');

		$this->start_controls_tab(
			'tab_menu_item_normal',
			[
				'label' => __('Normal', 'bayone_plg'),
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'menu_typography',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .bayone-nav .navigation li a',
			]
		);

		$this->add_control(
			'menu_color',
			[
				'label' => __('Color', 'bayone_plg'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .bayone-nav .navigation > li a, {{WRAPPER}} .bayone-nav.default li.menu-item-has-children > a:after' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'menu_color_dark_mode',
			[
				'label' => esc_html__('Color (Dark Mode)', 'bayone_plg'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'@media (prefers-color-scheme: dark){ body.bayone-auto-mode {{WRAPPER}} .bayone-nav .navigation > li a' => 'color: {{VALUE}};',
					'} body.bayone-dark-mode {{WRAPPER}} .bayone-nav .navigation > li a' => 'color: {{VALUE}};',
					'@media (prefers-color-scheme: dark){ body.bayone-auto-mode {{WRAPPER}} .bayone-nav.default li.menu-item-has-children > a:after' => 'color: {{VALUE}};',
					'} body.bayone-dark-mode {{WRAPPER}} .bayone-nav.default li.menu-item-has-children > a:after' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'menu_border',
				'selector' => '{{WRAPPER}} .bayone-nav .navigation > li',
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'menu_border_radius',
			[
				'label' => esc_html__('Border Radius', 'bayone_plg'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .bayone-nav .navigation > li' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'menu_margin',
			[
				'label' => esc_html__('Item Margin', 'bayone_plg'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .bayone-nav .navigation > li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'menu_padding',
			[
				'label' => esc_html__('Item Padding', 'bayone_plg'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .bayone-nav .navigation > li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'menu_item_shadow',
				'selector' => '{{WRAPPER}} .bayone-nav .navigation > li',
			]
		);

		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_menu_item_hover',
			[
				'label' => __('Hover', 'bayone_plg'),
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'menu_typography_hover',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .bayone-nav .navigation li a:hover',
			]
		);

		$this->add_responsive_control(
			'padding_underline_menu_item',
			[
				'label' => __('Underline position (px)', 'bayone_plg'),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 50,
						'min' => -50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .bayone-nav .underline.top > .menu-item a:before' => 'top: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .bayone-nav .underline.bottom > .menu-item a:before' => 'bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'underline_color_hover',
			[
				'label' => __('Underline Color', 'bayone_plg'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .bayone-nav .underline > .menu-item a:before' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'menu_color_hover',
			[
				'label' => __('Color', 'bayone_plg'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .bayone-nav .navigation > li a:hover, {{WRAPPER}} .bayone-nav.default li.menu-item-has-children > a:hover:after' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'menu_color_hover_dark_mode',
			[
				'label' => esc_html__('Color (Dark Mode)', 'bayone_plg'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'@media (prefers-color-scheme: dark){ body.bayone-auto-mode {{WRAPPER}} .bayone-nav .navigation > li a:hover' => 'color: {{VALUE}};',
					'} body.bayone-dark-mode {{WRAPPER}} .bayone-nav .navigation > li a:hover' => 'color: {{VALUE}};',
					'@media (prefers-color-scheme: dark){ body.bayone-auto-mode {{WRAPPER}} .bayone-nav.default li.menu-item-has-children > a:hover:after' => 'color: {{VALUE}};',
					'} body.bayone-dark-mode {{WRAPPER}} .bayone-nav.default li.menu-item-has-children > a:hover:after' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'menu_background_hover',
			[
				'label' => __('Background', 'bayone_plg'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .bayone-nav .navigation > li:hover' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'menu_border_hover',
				'selector' => '{{WRAPPER}} .bayone-nav .navigation > li:hover a',
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'menu_border_radius_hover',
			[
				'label' => esc_html__('Border Radius', 'bayone_plg'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .bayone-nav .navigation > li:hover a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'menu_item_shadow_hover',
				'selector' => '{{WRAPPER}} .bayone-nav .navigation > li:hover',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_menu_item_active',
			[
				'label' => __('Active', 'bayone_plg'),
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'menu_typography_active',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .bayone-nav .navigation > li.current_page_item a',
			]
		);

		$this->add_control(
			'menu_color_active',
			[
				'label' => __('Color', 'bayone_plg'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .bayone-nav .navigation > li.current_page_item a, {{WRAPPER}} .bayone-nav.default li.menu-item-has-children.current_page_item > a:after' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'menu_color_active_dark_mode',
			[
				'label' => esc_html__('Color (Dark Mode)', 'bayone_plg'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'@media (prefers-color-scheme: dark){ body.bayone-auto-mode {{WRAPPER}} .bayone-nav .navigation > li.current_page_item a' => 'color: {{VALUE}};',
					'} body.bayone-dark-mode {{WRAPPER}} .bayone-nav .navigation > li.current_page_item a' => 'color: {{VALUE}};',
					'@media (prefers-color-scheme: dark){ body.bayone-auto-mode {{WRAPPER}} .bayone-nav.default li.menu-item-has-children.current_page_item > a:after' => 'color: {{VALUE}};',
					'} body.bayone-dark-mode {{WRAPPER}} .bayone-nav.default li.menu-item-has-children.current_page_item > a:after' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'menu_background',
			[
				'label' => __('Background', 'bayone_plg'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .bayone-nav .navigation > li.current_page_item' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'menu_border_active',
				'selector' => '{{WRAPPER}} .bayone-nav .navigation > li.current_page_item a',
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'menu_border_radius_active',
			[
				'label' => esc_html__('Border Radius', 'bayone_plg'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .bayone-nav .navigation > li.current_page_item a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'menu_item_shadow_active',
				'selector' => '{{WRAPPER}} .bayone-nav .navigation > li.current_page_item',
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();




		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_submain-menu',
			[
				'label' => __('Main Sub-Menu', 'bayone_plg'),
				'tab' => Controls_Manager::TAB_STYLE,

			]
		);

		$this->add_control(
			'submenu_arrow_color',
			[
				'label' => __('Arrow Color', 'bayone_plg'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .bayone-nav.default li.menu-item-has-children > a:after' => 'color: {{VALUE}} !important;',
				],
			]
		);

		$this->start_controls_tabs(
			'style_submain-menu_tabs'
		);

		$this->start_controls_tab(
			'style_submain-menu_normal_tab',
			[
				'label' => esc_html__('Normal', 'textdomain'),
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'submenu_typography',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .bayone-nav .menu-wrapper ul li ul li a',
			]
		);

		$this->add_control(
			'submenu_color',
			[
				'label' => __('Color', 'bayone_plg'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .bayone-nav .menu-wrapper ul li ul li a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'submenu_color_dark_mode',
			[
				'label' => esc_html__('Color (Dark Mode)', 'bayone_plg'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'@media (prefers-color-scheme: dark){ body.bayone-auto-mode {{WRAPPER}} .bayone-nav .menu-wrapper ul li ul li a' => 'color: {{VALUE}};',
					'} body.bayone-dark-mode {{WRAPPER}} .bayone-nav .menu-wrapper ul li ul li a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'style_submain-menu_hover_tab',
			[
				'label' => esc_html__('Hover', 'textdomain'),
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'submenu_typography_hover',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .bayone-nav .menu-wrapper ul li ul li a:hover',
			]
		);

		$this->add_control(
			'submenu_color_hover',
			[
				'label' => __('Color', 'bayone_plg'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .bayone-nav .menu-wrapper ul li ul li a:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'submenu_color_hover_dark_mode',
			[
				'label' => esc_html__('Color (Dark Mode)', 'bayone_plg'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'@media (prefers-color-scheme: dark){ body.bayone-auto-mode {{WRAPPER}} .bayone-nav .menu-wrapper ul li ul li a:hover' => 'color: {{VALUE}};',
					'} body.bayone-dark-mode {{WRAPPER}} .bayone-nav .menu-wrapper ul li ul li a:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_responsive_control(
			'padding_vertical_submenu_item',
			[
				'label' => __('Top Position (px)', 'bayone_plg'),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 150,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .bayone-nav .menu-wrapper ul li ul' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'boxes_border_radius',
			[
				'label' => __('Border Radius', 'bayone_plg'),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .menu-wrapper ul li ul' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_mobile-menu',
			[
				'label' => __('Mobile Menu', 'bayone_plg'),
				'tab' => Controls_Manager::TAB_STYLE,

			]
		);

		$this->add_control(
			'hamburger_menu_color',
			[
				'label' => __('Hamburger Icon Color', 'bayone_plg'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .hamburger__icon' => 'background: {{VALUE}};',
					'{{WRAPPER}} .hamburger__icon::before' => 'background: {{VALUE}};',
					'{{WRAPPER}} .hamburger__icon::after' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'close_x_color',
			[
				'label' => __('Close X Icon Color', 'bayone_plg'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .hamburger.active .hamburger__icon::before' => 'background: {{VALUE}};',
					'{{WRAPPER}} .hamburger.active .hamburger__icon::after' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'padding_top_mobile_menu',
			[
				'label' => __('Top position', 'bayone_plg'),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .fat-nav' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'mobile_menu_wrapper',
			[
				'label' => esc_html__('Wrapper Padding', 'bayone_plg'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .fat-nav__wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.1.0
	 *
	 * @access protected
	 */
	protected function render()
	{
		$settings = $this->get_settings();

		$nav_menu = array('menu' => $settings['bayone_menu'], 'echo' => true, 'menu_id' => '', 'items_wrap' => '<ul id="%1$s" class="home-nav navigation %2$s">%3$s</ul>');
?>

		<div class="bayone-nav <?php echo esc_attr($settings['menu_style']); ?>">
			<div class="main-menu menu-wrapper d-none d-md-block">
				<?php
				if (!empty($settings['bayone_menu'])) {
					wp_nav_menu($nav_menu);
				}; ?>
			</div><!--/.menu-box -- hidden-xs hidden-sm-->
			<div class="mobile-wrapper d-block d-md-none"> <!-- hidden-lg hidden-md -->
				<a href="#" class="hamburger">
					<div class="hamburger__icon"></div>
				</a>
				<div class="fat-nav">
					<div class="fat-nav__wrapper">
						<?php
						$menuParameters = array(
							'menu' => $settings['bayone_menu'],
							'container'       => true,
							'items_wrap'      => '<ul id="%1$s" class="mob-nav  %2$s">%3$s</ul>',
							'depth'           => 0,
						);
						?>
						<div class="fat-list"> <?php echo strip_tags(wp_nav_menu($menuParameters), '<a>'); ?></div>
					</div>
				</div>
			</div><!--/.box-mobile-->
		</div>

<?php }

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.1.0
	 *
	 * @access protected
	 */
	protected function content_template()
	{
	}
}
