<?php
namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;

if (!defined('ABSPATH')) exit;

class Bayone_Noise_background extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'bayone-noise-background';
    }

    public function get_title()
    {
        return __('Bayone Noise Background', 'bayone_plg');
    }

    public function get_icon()
    {
        return 'eicon-background';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Noise Background Settings', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'background_image',
            [
                'label' => __('Background Image', 'bayone_plg'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'selectors' => [
                    '{{WRAPPER}} .bayone-noise-background' => 'background-image: url("{{URL}}");',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="bayone-noise-background"></div>
        <?php
    }
}
