<?php
namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Utils;


if (!defined('ABSPATH')) exit;

class Bayone_Numbers extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'bayone-numbers';
    }

    public function get_title()
    {
        return __('Bayone Numbers', 'bayone_plg');
    }

    public function get_icon()
    {
        return ' eicon-number-field';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Numbers Settings', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'number',
            [
                'label' => __('Number Text', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('40', 'bayone_plg'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'heading_text',
            [
                'label' => __('Heading Text', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('This is a heading', 'bayone_plg'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'heading_color',
            [
                'label' => __('Title Color', 'bayone_plg'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff', // Default color value
                'selectors' => [
                    '{{WRAPPER}} .bayone-numbers h6' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Heading_typography',
                'label' => __('Text Typography', 'bayone_plg'),
                'selector' => '{{WRAPPER}} .bayone-numbers h6',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Number_typography',
                'label' => __('Number Typography', 'bayone_plg'),
                'selector' => '{{WRAPPER}} .bayone-numbers h3',
            ]
        );

//        $this->add_control(
//            'Number_color',
//            [
//                'label' => __('Number Color', 'bayone_plg'),
//                'type' => Controls_Manager::COLOR,
//                'default' => '#ffffff', // Default color value
//                'selectors' => [
//                    '{{WRAPPER}} .bayone-numbers h3' => 'color: {{VALUE}};',
//                ],
//            ]
//        );

        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $heading_text = $settings['heading_text'];
        $number = $settings['number'];
        ?>
        <div class="bayone-numbers">
            <div>
                <div class="item md-mb50">
                    <h3 class="stroke pb-30 mb-30 bord-thin-bottom"><?=$number?></h3>
                    <h6><?=$heading_text?></h6>
                </div>
            </div>
        </div>
        <?php
    }

    /**
     * Render the widget output in the editor.
     *
     * Written as a Backbone JavaScript template and used to generate the live preview.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function content_template()
    {
    }




}