<?php
namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;

if (!defined('ABSPATH')) exit;

class Bayone_Page_Border extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'bayone-page-border';
    }

    public function get_title()
    {
        return __('Bayone Page Border', 'bayone_plg');
    }

    public function get_icon()
    {
        return 'eicon-divider';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Page Border Settings', 'bayone_plg'),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'label' => __('Border', 'bayone_plg'),
                'selector' => '{{WRAPPER}} .bayone-page-border',
            ]
        );

        $this->add_control(
            'rotation',
            [
                'label' => __('Border Rotation', 'bayone_plg'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['deg'],
                'range' => [
                    'deg' => [
                        'min' => 0,
                        'max' => 360,
                    ],
                ],
                'default' => [
                    'unit' => 'deg',
                    'size' => 0,
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $rotation = $settings['rotation']['size'];
        ?>
        <div class="bayone-page-border"></div>
        <style>
            .bayone-page-border {
                transform: rotate(<?php echo $rotation; ?>deg);
                box-sizing: border-box !important;
            }
        </style>
        <?php
    }

}