<?php
namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;

if (!defined('ABSPATH')) exit;

class Bayone_Portfolio_Grid_Classic extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'bayone-portfolio-grid-classic';
    }

    public function get_title()
    {
        return __('Bayone Portfolio Grid Classic', 'bayone_plg');
    }

    public function get_script_depends() {
        return [ 'bayone-gallery','bayone-inter-fixed-text','lib-isotope.min'];
    }


    public function get_icon()
    {
        return 'eicon-gallery-grid';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Portfolio Grid Classic Settings', 'bayone_plg'),
            ]
        );

//        $this->add_control(
//            'title',
//            [
//                'label' => __('Title', 'bayone_plg'),
//                'type' => Controls_Manager::TEXT,
//                'default' => __('Recent Work', 'bayone_plg'),
//                'dynamic' => [
//                    'active' => true,
//                ],
//            ]
//        );

//        $this->add_control(
//            'category',
//            [
//                'label' => __('Category', 'bayone_plg'),
//                'type' => Controls_Manager::SELECT,
//                'default' => '',
//                'options' => $this->bayone_tax_options(),
//            ]
//        );

        $this->add_control(
            'portfolio_item',
            [
                'label' => __( 'Item to display', 'bayone_blg' ),
                'type' => Controls_Manager::NUMBER,
                'default' => '8',
            ]
        );

        $this->add_control(
            'port_order',
            [
                'label' => __( 'Orders', 'bayone_blg' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'DESC' => __( 'Descending', 'bayone_blg' ),
                    'ASC' => __( 'Ascending', 'bayone_blg' ),
                    'rand' => __( 'Random', 'bayone_blg' ),
                ],
                'default' => 'DESC',
            ]
        );

        $this->add_control(
            'selected_terms',
            [
                'label' => __('Select Taxonomy Terms', 'bayone_plg'),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->get_taxonomy_terms(), // Create a method to retrieve taxonomy terms
                'default' => [],
            ]
        );

        $this->add_control(
            'selected_tags',
            [
                'label' => __('Select Tags', 'bayone_plg'),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->get_tag_options(),
                'default' => [],
            ]
        );


        $this->add_control(
            'heading_color',
            [
                'label' => __('Heading Color', 'bayone_plg'),
                'type' => Controls_Manager::COLOR,
                'default' => '#333333', // Default color value
                'selectors' => [
                    '{{WRAPPER}} .bayone-portfolio-classic .item h5 , .bayone-portfolio-grid .item h5 , .bayone-inter-fixed-text .links-text li h2 ' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'portfolio_style',
            [
                'label' => __('Portfolio Style', 'bayone_plg'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'grid' => __('Grid', 'bayone_plg'),
                    'classic' => __('Classic', 'bayone_plg'),
                    'fixed-text'=>__('Fixed Text', 'bayone_plg'),
                ],
                'default' => 'classic',
            ]
        );


//        $this->add_control(
//            'h5_typography',
//            [
//                'label' => __('H5 Typography', 'bayone_plg'),
//                'type' => Controls_Manager::TYPOGRAPHY,
//                'default' => [
//                    'font_size' => '',
//                    'font_weight' => '',
//                    'font_family' => '',
//                    'font_style' => '',
//                    'line_height' => '',
//                    'letter_spacing' => '',
//                    'text_transform' => '',
//                ],
//                'selectors' => [
//                    '{{WRAPPER}} .bayone-portfolio-grid-classic .item h5' => '{{VALUE}}',
//                ],
//            ]
//        );


        $this->add_control(
            'span_color',
            [
                'label' => __('Span Color', 'bayone_plg'),
                'type' => Controls_Manager::COLOR,
                'default' => '#777777', // Default color value
                'selectors' => [
                    '{{WRAPPER}} .bayone-portfolio-classic .item span , .bayone-portfolio-grid .item span , .bayone-inter-fixed-text .rest span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }
    protected function render() {
        $settings = $this->get_settings_for_display();
        $selected_terms = $settings['selected_terms'];
        $selected_tags = $settings['selected_tags'];
        if ($settings['port_order'] != 'rand') {
            $order = 'order';
            $ord_val = $settings['port_order'];
        } else {
            $order = 'orderby';
            $ord_val = 'rand';
        }
        $bayone_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
        $query_args = array(
            'paged' => $bayone_paged,
            'posts_per_page' => $settings['portfolio_item'],
            'post_type' => 'portfolio',
            $order => $ord_val,
        );
        if (!empty($selected_terms)) {
            $query_args['tax_query'] = array(
                array(
                    'taxonomy' => 'portfolio_category',
                    'field' => 'term_id',
                    'terms' => $selected_terms,
                ),
            );
        }
        if (!empty($selected_tags)) {
            $query_args['tax_query'][] = array(
                'taxonomy' => 'porto_tag',
                'field' => 'term_id',
                'terms' => $selected_tags,
            );
        }
        $bayone_work = new \WP_Query($query_args);
        ?>
            <?php if($settings['portfolio_style']=='classic') :  ?>
                <section class="bayone-portfolio-classic portfolio pt-50 pb-40 bord-thin-bottom">
            <div class="bayone-gallery">
                <div class="row lg-marg">
                    <?php $itemCount=1; if ($bayone_work->have_posts()) : while  ($bayone_work->have_posts()) : $bayone_work->the_post(); global $post ; ?>
                        <div class="items col-md-<?= ($itemCount != 3) ? "6" : "12"; ?>">
                                    <div class="item mb-80">
                                        <div class="img">
                                            <img src="<?= esc_url(get_the_post_thumbnail_url());?>" alt="">
                                            <a href="<?= get_the_permalink() ?>" class="animsition-link link-overlay"></a>
                                        </div>
                                        <div class="info mt-30">
                                            <?php
                                            $bayone_work_taxonomy = 'portfolio_category';
                                            $bayone_work_taxs = wp_get_post_terms($post->ID, $bayone_work_taxonomy);
                                            ?>
                                            <?php foreach ($bayone_work_taxs as $bayone_work_tax) : ?>
                                                <span class="mb-5"><?= $bayone_work_tax->name ?></span>
                                            <?php endforeach; ?>
                                            <h5><?= get_the_title() ?></h5>
                                        </div>
                                    </div>
                        </div>
                    <?php if ($itemCount === 3) {
                                $itemCount = 0;
                            }
                        $itemCount++;endwhile;  wp_reset_postdata(); endif; ?>
                </div>
            </div>
        </section>
            <?php elseif($settings['portfolio_style']=='grid'): ?>
                <section class="bayone-portfolio-grid portfolio pt-50">
                <div class="pb-40 bord-thin-bottom">
                    <div class="bayone-gallery">
                        <div class="row lg-marg">
                    <?php $itemCount=1; if ($bayone_work->have_posts()) : while  ($bayone_work->have_posts()) : $bayone_work->the_post(); global $post ; ?>
                        <div class="items col-lg-4 col-md-6 <?php if ($itemCount==2) : ?> mt-80 <?php endif; ?>  ">
                                <div class="item mb-80">
                                    <div class="img">
                                        <img src="<?= esc_url(get_the_post_thumbnail_url());?>" alt="">
                                        <div class="info-over">
                                            <h5><?= get_the_title() ?></h5>
                                            <?php
                                            $bayone_work_taxonomy = 'portfolio_category';
                                            $bayone_work_taxs = wp_get_post_terms($post->ID, $bayone_work_taxonomy);
                                            ?>
                                            <?php foreach ($bayone_work_taxs as $bayone_work_tax) : ?>
                                                <span><?= $bayone_work_tax->name ?></span>
                                            <?php endforeach; ?>
                                        </div>
                                        <a href="<?= get_the_permalink() ?>" class="animsition-link link-overlay"></a>
                                    </div>
                                </div>
                            </div>
                            <?php $itemCount++; endwhile;  wp_reset_postdata(); endif; ?>
                        </div>
                    </div>
                </div>
            </section>
            <?php else: ?>
            <section class="bayone-inter-fixed-text section-padding pt-40 o-hidden">
                <div class="">
                    <div class="links-img">
                        <div class="row">
                            <?php  $col=1; $itemCount=1; if ($bayone_work->have_posts()) : while  ($bayone_work->have_posts()) : $bayone_work->the_post(); global $post ; ?>
                                <?php if($col==1 || $col==5 || $col==2 || $col==4) : ?>
                                <div class="col-lg-<?= ($col==1 || $col==5) ? "5":"7" ?> items">
                                    <div class="item">
                                        <div class="img" data-tab="tab-<?=$itemCount?>">
                                            <img src="<?= esc_url(get_the_post_thumbnail_url());?>" alt="">
                                            <a href="<?= get_the_permalink() ?>" class="animsition-link link-overlay"></a>
                                        </div>
                                    </div>
                                </div>
                                <?php else:?>
                                    <div class="col-lg-12 items">
                                        <div class="row justify-content-center">
                                            <div class="col-lg-8">
                                                <div class="item">
                                                    <div class="img" data-tab="tab-3">
                                                        <img src="<?= esc_url(get_the_post_thumbnail_url());?>" alt="">
                                                        <a href="<?= get_the_permalink() ?>" class="animsition-link link-overlay"></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                             <?php if($col==6)$col=0; $itemCount++;$col++; endwhile;  wp_reset_postdata(); endif; ?>
                        </div>
                    </div>
                </div>
                <div class="links-text">
                    <ul class="rest">
                    <?php $itemCount=1; if ($bayone_work->have_posts()) : while  ($bayone_work->have_posts()) : $bayone_work->the_post(); global $post ; ?>
                        <li id="tab-<?=$itemCount?>">
                            <?php
                            $bayone_work_taxonomy = 'portfolio_category';
                            $bayone_work_taxs = wp_get_post_terms($post->ID, $bayone_work_taxonomy);
                            ?>
                            <?php foreach ($bayone_work_taxs as $bayone_work_tax) : ?>
                                <span class="tag"><?= $bayone_work_tax->name ?></span>
                            <?php endforeach; ?>
                            <h2 class="heading-color"><?=get_the_title()?></h2>
                        </li>
                    <?php $itemCount++; endwhile;  wp_reset_postdata(); endif; ?>
                    </ul>
                </div>
            </section>
            <?php endif; ?>
        <?php
    }


    private function get_taxonomy_terms() {
        $terms = get_terms(array(
            'taxonomy' => 'portfolio_category', // Replace with your actual taxonomy slug
            'hide_empty' => true,
        ));

        $options = [];
        foreach ($terms as $term) {
            $options[$term->term_id] = $term->name;
        }

        return $options;
    }

    private function get_tag_options() {
        $tags = get_terms(array(
            'taxonomy' => 'porto_tag',
            'hide_empty' => true,
        ));

        $options = [];
        foreach ($tags as $tag) {
            $options[$tag->term_id] = $tag->name;
        }

        return $options;
    }

}
