<?php
namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Bayone_Portfolio_Slider extends Widget_Base
{
    public function get_name()
    {
        return 'bayone-portfolio-slider';
    }
    public function get_style_depends() {
        return ['lib-swiper5.min.css'];
    }

    public function get_script_depends() {
        return ['lib-swiper.min','lib-parallax.min','lib-animsition.min','bayone-portfolio-slider' , 'bayone-parallax-swiper' ];
    }


    public function get_title()
    {
        return __('Bayone Portfolio Slider', 'bayone_plg');
    }

    public function get_icon()
    {
        return 'eicon-slider-album';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Portfolio Sliders', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'portfolio_item',
            [
                'label' => __( 'Item to display', 'bayone_blg' ),
                'type' => Controls_Manager::NUMBER,
                'default' => '8',
            ]
        );

        $this->add_control(
            'port_order',
            [
                'label' => __( 'Orders', 'bayone_blg' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'DESC' => __( 'Descending', 'bayone_blg' ),
                    'ASC' => __( 'Ascending', 'bayone_blg' ),
                    'rand' => __( 'Random', 'bayone_blg' ),
                ],
                'default' => 'DESC',
            ]
        );

        $this->add_control(
            'slider_style',
            [
                'label' => __('Slider Style', 'bayone_plg'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'half' => __('half', 'bayone_plg'),
                    'full' => __('full', 'bayone_plg'),
                    'carousel' => __('carousel', 'bayone_plg')
                ],
                'default' => 'half',
            ]
        );

        $this->add_control(
            'prev_btn_text',
            [
                'label' => __('Previous Button Text', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Önceki', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'next_btn_text',
            [
                'label' => __('Next Button Text', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Sonraki', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'selected_terms',
            [
                'label' => __('Select Taxonomy Terms', 'bayone_plg'),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->get_taxonomy_terms(), // Create a method to retrieve taxonomy terms
                'default' => [],
            ]
        );

        $this->add_control(
            'selected_tags',
            [
                'label' => __('Select Tags', 'bayone_plg'),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->get_tag_options(),
                'default' => [],
            ]
        );

        $this->add_control(
			'scroll_with_mouse_wheel',
			[
				'label' => esc_html__( 'Scroll With Mouse Wheel', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'On', 'textdomain' ),
				'label_off' => esc_html__( 'Off', 'textdomain' ),
				'return_value' => 'yes',
				'default' => 'yes',
                'condition' => [
                    'slider_style' => 'full'
                ]
			]
		);


        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $slider_style=$settings['slider_style'];
        $selected_terms = $settings['selected_terms'];
        $selected_tags = $settings['selected_tags'];
        $next = $settings['next_btn_text'];
        $prev = $settings['prev_btn_text'];
        $mouse_wheel = $settings['scroll_with_mouse_wheel'] == 'yes' ? 'true' : 'false';
        if ($settings['port_order'] != 'rand') {
            $order = 'order';
            $ord_val = $settings['port_order'];
        } else {
            $order = 'orderby';
            $ord_val = 'rand';
        }
        $bayone_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
        $query_args = array(
            'paged' => $bayone_paged,
            'posts_per_page' => $settings['portfolio_item'],
            'post_type' => 'portfolio',
            $order => $ord_val,
        );
        if (!empty($selected_terms)) {
            $query_args['tax_query'] = array(
                array(
                    'taxonomy' => 'portfolio_category',
                    'field' => 'term_id',
                    'terms' => $selected_terms,
                ),
            );
        }
        if (!empty($selected_tags)) {
            $query_args['tax_query'][] = array(
                'taxonomy' => 'porto_tag',
                'field' => 'term_id',
                'terms' => $selected_tags,
            );
        }
        $bayone_work = new \WP_Query($query_args);
        ?>
            <?php if($slider_style=='half') : ?>
                <header class="bayone-half-slider">
                    <div class="gallery-img">
                        <div class="swiper-container">
                            <div class="swiper-wrapper">
                                <?php if ($bayone_work->have_posts()) : while  ($bayone_work->have_posts()) : $bayone_work->the_post(); global $post ; ?>
                                    <div class="swiper-slide">
                                        <div class="bg-img" data-background="<?= esc_url(get_the_post_thumbnail_url()); ?>" data-overlay-dark="3">
                                            <a href="<?= get_the_permalink(); ?>" class="animsition-link"></a>
                                        </div>
                                    </div>
                                <?php endwhile;  wp_reset_postdata(); endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="gallery-text">
                        <div class="swiper-container">
                            <div class="swiper-wrapper">
                                <?php if ($bayone_work->have_posts()) : while  ($bayone_work->have_posts()) : $bayone_work->the_post(); global $post ; ?>
                                    <div class="swiper-slide">
                                        <div class="text cursor-pointer">
                                            <h6>
                                                <?php
                                                $bayone_work_taxonomy = 'portfolio_category';
                                                $bayone_work_taxs = wp_get_post_terms($post->ID, $bayone_work_taxonomy);
                                                ?>
                                                <?php foreach ($bayone_work_taxs as $bayone_work_tax) : ?>
                                                    <span><?= $bayone_work_tax->name ?></span>
                                                <?php endforeach; ?>
                                            </h6>
                                            <h4 class="f-bold"><a href="<?= get_the_permalink(); ?>"><?= get_the_title(); ?></a></h4>
                                        </div>
                                    </div>
                                <?php endwhile;  wp_reset_postdata(); endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-controls">
                        <div class="swiper-button-next swiper-nav-ctrl cursor-pointer">
                            <div>
                                <span><?= $next ?></span>
                            </div>
                            <div><i class="fas fa-chevron-right"></i></div>
                        </div>
                        <div class="swiper-button-prev swiper-nav-ctrl cursor-pointer">
                            <div><i class="fas fa-chevron-left"></i></div>
                            <div>
                                <span><?= $prev ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-pagination"></div>
                </header>
            <?php elseif ($slider_style=='full') : ?>
                <header class="bayone-full-showcase" data-mouse-wheel="<?php echo $mouse_wheel; ?>">
                    <div class="swiper-container parallax-slider">
                        <div class="swiper-wrapper">
                            <?php $itemCount=1; if ($bayone_work->have_posts()) : while  ($bayone_work->have_posts()) : $bayone_work->the_post(); global $post ; ?>
                                <div class="swiper-slide">
                                    <div class="bg-img valign" data-background="<?= esc_url(get_the_post_thumbnail_url()); ?>"
                                     data-overlay-dark="<?= ($itemCount == 6) ? "4" : (($itemCount == 7) ? "2" : "3") ?>">
                                        <div class="container">
                                            <div class="row">
                                                <div class="col-lg-11 offset-lg-1">
                                                    <div class="caption">
                                                        <h6 class="sub-title mb-30" data-swiper-parallax="-1000">© <?= get_the_date('Y'); ?> <br>
                                                            <?php
                                                            $bayone_work_taxonomy = 'portfolio_category';
                                                            $bayone_work_taxs = wp_get_post_terms($post->ID, $bayone_work_taxonomy);
                                                            ?>
                                                            <?php foreach ($bayone_work_taxs as $bayone_work_tax) : ?>
                                                            <?= $bayone_work_tax->name ?>
                                                        </h6>
                                                        <?php endforeach; ?>
                                                        <h1>
                                                            <a href="<?= get_the_permalink(); ?>" class="animsition-link">
                                                                <?php if ($itemCount == 2 || $itemCount == 3 || $itemCount == 7) :
                                                                    $title_parts = explode(' ', get_the_title(), 2);
                                                                    ?>
                                                                    <span data-swiper-parallax="-2000"><?= esc_html($title_parts[0]); ?></span>
                                                                    <br>
                                                                    <span data-swiper-parallax="-3000"><?= esc_html($title_parts[1]); ?></span>
                                                                <?php else : ?>
                                                                    <span data-swiper-parallax="-2000"><?= get_the_title(); ?></span>
                                                                <?php endif; ?>
                                                            </a>
                                                        </h1>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                </div>
                                </div>
                            <?php if($itemCount==8){$itemCount=0;} $itemCount++; endwhile;  wp_reset_postdata(); endif; ?>
                        </div>
                        <!-- slider setting -->
                        <div class="swiper-controls">
                            <div class="swiper-button-next swiper-nav-ctrl cursor-pointer">
                                <div>
                                    <span><?=$next?></span>
                                </div>
                                <div><i class="fas fa-chevron-right"></i></div>
                            </div>
                            <div class="swiper-button-prev swiper-nav-ctrl cursor-pointer">
                                <div><i class="fas fa-chevron-left"></i></div>
                                <div>
                                    <span><?=$prev?></span>
                                </div>
                            </div>
                        </div>
                        <div class="swiper-pagination"></div>
                    </div>
                </header>
            <?php elseif ($slider_style=='carousel') :  ?>
                <header class="bayone-carousel-slider valign">
                    <div class="full-width">
                        <div class="gallery-img">
                            <div class="swiper-container">
                                <div class="swiper-wrapper">
                                    <?php if ($bayone_work->have_posts()) : while  ($bayone_work->have_posts()) : $bayone_work->the_post(); global $post ; ?>
                                        <div class="swiper-slide">
                                            <div class="bg-img" data-background="<?= esc_url(get_the_post_thumbnail_url()); ?>"
                                                 data-overlay-dark="3">
                                                <a href="<?= get_the_permalink(); ?>" class="animsition-link"></a>
                                            </div>
                                        </div>
                                    <?php endwhile;  wp_reset_postdata(); endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="gallery-text">
                            <div class="swiper-container">
                                <div class="swiper-wrapper">
                                    <?php if ($bayone_work->have_posts()) : while  ($bayone_work->have_posts()) : $bayone_work->the_post(); global $post ; ?>
                                        <div class="swiper-slide">
                                            <div class="text">
                                                <h4><a href="<?= get_the_permalink(); ?>"><?=get_the_title()?></a></h4>
                                                <h6>
                                                    <?php
                                                    $bayone_work_taxonomy = 'portfolio_category';
                                                    $bayone_work_taxs = wp_get_post_terms($post->ID, $bayone_work_taxonomy);
                                                    ?>
                                                    <?php foreach ($bayone_work_taxs as $bayone_work_tax) : ?>
                                                        <span><?= $bayone_work_tax->name ?></span>
                                                    <?php endforeach; ?>
                                                </h6>
                                            </div>
                                        </div>
                                    <?php endwhile;  wp_reset_postdata(); endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-controls">
                        <div class="swiper-button-next swiper-nav-ctrl cursor-pointer">
                            <div>
                                <span>Sonraki</span>
                            </div>
                            <div><i class="fas fa-chevron-right"></i></div>
                        </div>
                        <div class="swiper-button-prev swiper-nav-ctrl cursor-pointer">
                            <div><i class="fas fa-chevron-left"></i></div>
                            <div>
                                <span>Önceki</span>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-pagination"></div>
                </header>
            <?php endif; ?>
        <?php
    }



    private function get_taxonomy_terms() {
        $terms = get_terms(array(
            'taxonomy' => 'portfolio_category', // Replace with your actual taxonomy slug
            'hide_empty' => true,
        ));

        $options = [];
        foreach ($terms as $term) {
            $options[$term->term_id] = $term->name;
        }

        return $options;
    }

    private function get_tag_options() {
        $tags = get_terms(array(
            'taxonomy' => 'porto_tag',
            'hide_empty' => true,
        ));

        $options = [];
        foreach ($tags as $tag) {
            $options[$tag->term_id] = $tag->name;
        }

        return $options;
    }

}
