<?php
namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;

if (!defined('ABSPATH')) exit;

class Bayone_Section_Heading extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'bayone-section-section-heading';
    }

    public function get_title()
    {
        return __('Bayone Section Heading', 'bayone_plg');
    }

    public function get_icon()
    {
        return 'eicon-heading';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Image Text Settings', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Title', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Our capabilities', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'left_text',
            [
                'label' => __('left text', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('All Features', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'btn_link',
            [
                'label' => __('Button Link', 'bayone_plg'),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => '#',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('Button', 'bayone_plg'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'bayone_plg'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff', // Default color value
                'selectors' => [
                    '{{WRAPPER}} .bayone-section-heading .sec-head h3' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'subtitle_color',
            [
                'label' => __('Subtitle Color', 'bayone_plg'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .bayone-section-heading .sec-head span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'selector' => '{{WRAPPER}} .bayone-section-heading .sub-title.bord',
            ]
        );

        $this->add_control(
            'border_radius',
            [
                'label' => __('Border Radius', 'bayone_plg'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .bayone-section-heading .sub-title.bord' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );


        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $title = $settings['title'];
        $left_text = $settings['left_text'];
        $btn_link = $settings['btn_link']['url'];
        ?>
        <div class="bayone-section-heading">
            <div class="sec-head bord-thin-bottom pb-20">
                <div class="d-flex align-items-center">
                <div>
                    <h3 class="f-bold text-u"><?=$title?></h3>
                </div>
                <div class="ms-auto">
                    <div class="d-flex align-items-center">
                        <span class="sub-title ls1 bord"><?=$left_text?></span>
                        <a href="<?=$btn_link?>" class="arrow animsition-link">
                            <svg width="18" height="18" viewBox="0 0 18 18" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M13.922 4.5V11.8125C13.922 11.9244 13.8776 12.0317 13.7985 12.1108C13.7193 12.1899 13.612 12.2344 13.5002 12.2344C13.3883 12.2344 13.281 12.1899 13.2018 12.1108C13.1227 12.0317 13.0783 11.9244 13.0783 11.8125V5.51953L4.79547 13.7953C4.71715 13.8736 4.61092 13.9176 4.50015 13.9176C4.38939 13.9176 4.28316 13.8736 4.20484 13.7953C4.12652 13.717 4.08252 13.6108 4.08252 13.5C4.08252 13.3892 4.12652 13.283 4.20484 13.2047L12.4806 4.92188H6.18765C6.07577 4.92188 5.96846 4.87743 5.88934 4.79831C5.81023 4.71919 5.76578 4.61189 5.76578 4.5C5.76578 4.38811 5.81023 4.28081 5.88934 4.20169C5.96846 4.12257 6.07577 4.07813 6.18765 4.07812H13.5002C13.612 4.07813 13.7193 4.12257 13.7985 4.20169C13.8776 4.28081 13.922 4.38811 13.922 4.5Z"
                                    fill="currentColor"></path>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
            </div>
        </div>
        <?php
    }
}
