<?php
namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;


if (!defined('ABSPATH')) exit;

class Bayone_Serv_Inline extends Widget_Base
{
    public function get_name()
    {
        return 'bayone-serv-serv-inline';
    }

    public function get_title()
    {
        return __('Serv Inline', 'bayone_plg');
    }

    public function get_icon()
    {
        return 'eicon-table';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_items',
            [
                'label' => __('Serv Inline Items', 'bayone_plg'),
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'item_title',
            [
                'label' => __('Title', 'bayone_plg'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Accordion Item', 'bayone_plg'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'item_content',
            [
                'label' => __('Content', 'bayone_plg'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Accordion item content...', 'bayone_plg'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'item_delay',
            [
                'label' => __('Animation Delay', 'bayone_plg'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 0.2,
                'description' => __('Enter the animation delay in seconds for this item.', 'bayone_plg'),
            ]
        );

        $repeater->add_control(
            'btn_text',
            [
                'label' => __('Button Text', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => __('Read More', 'bayone_plg'),
            ]
        );

        $repeater->add_control(
            'btn_link',
            [
                'label' => __('Button Link', 'bayone_plg'),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => '#',
                ],
            ]
        );


        $this->add_control(
            'serv_items',
            [
                'label' => __('Accordion Items', 'bayone_plg'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ item_title }}}',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="bayone-serv-inline">
            <div class="row justify-content-end">
                <?php $count=1; foreach ($settings['serv_items'] as $index => $item) : ?>
                    <div class="item pb-30 <?= ($count==1) ? "pt-30":"" ?> mb-30 <?= ($count==1) ? "bord-thin-top":"" ?> bord-thin-bottom wow fadeInUp"
                             data-wow-delay="<?=$item['item_delay']?>">
                            <div class="d-flex align-items-center">
                                <div class="head">
                                    <span class="mb-10 opacity-8">0<?=$count?> /
                                        <span class="text-u ms-2"><?=$item['item_content']?></span>
                                    </span>
                                    <h5><?=$item['item_title']?></h5>
                                </div>
                                <div class="ms-auto">
                                    <div class="d-flex align-items-center">
                                        <a href="<?=$item['btn_link']['url']?>" class="animsition-link"><?=$item['btn_text']?></a>
                                        <span class="fz-30 pe-7s-angle-right"></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                <?php $count++; endforeach; ?>
            </div>
        </div>
        <?php
    }
}
