<?php
namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;

if (!defined('ABSPATH')) exit;

class Bayone_Social_Media extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'bayone-social-media';
    }

    public function get_title()
    {
        return __('Bayone Social Media', 'bayone_plg');
    }

    public function get_icon()
    {
        return 'eicon-footer';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    public function get_script_depends() {
        return ['lib-gsap.min', 'lib-ScrollTrigger.min', 'bayone-footer','lib-parallax.min', 'lib-page-lines'];
    }


    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Footer Settings', 'bayone_plg'),
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => __('Sub Title ', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('SOCIAL MEDIA', 'bayone_plg'),
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'social_title',
            [
                'label' => __('Social Text', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );
        $repeater->add_control(
            'social_link',
            [
                'label' => __('Social Link', 'bayone_plg'),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'items_list',
            [
                'label' => __('Social Media List', 'bayone_plg'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ social_title }}}',
            ]
        );
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $sub_title=$settings['sub_title'];
        $items_list = $settings['items_list'];
        ?>
        <div class="bayone-social-media">
            <div class="column">
                <h6 class="sub-title mb-30"><?=$sub_title?></h6>
                    <ul class="rest">
                        <?php foreach ($items_list as $item) : ?>
                            <li class="hover-this cursor-pointer">
                                <a href="<?=$item['social_link']['url']?>" class="hover-anim"><?=$item['social_title']?></a>
                            </li>
                        <?php endforeach;?>
                    </ul>
            </div>
        </div>
        <?php
    }
}
