<?php
namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;

if (!defined('ABSPATH')) exit;

class Bayone_Testimonials extends Widget_Base
{
    public function get_name()
    {
        return 'bayone-testimonials-testimonials';
    }

    public function get_title()
    {
        return __('Bayone Testimonials', 'bayone_plg');
    }

    public function get_icon()
    {
        return 'eicon-slider-album';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    public function get_script_depends() {
        return ['bayone-testimonials'];
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Testimonials Settings', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Title', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Testimonials', 'bayone_plg'),
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'heading_typography',
                'label' => __('Heading Typography', 'bayone_plg'),
                'selector' => '{{WRAPPER}} .bayone-testimonials .sec-head h3',
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'icon_image',
            [
                'label' => __('Icon Image', 'bayone_plg'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'testimonial',
            [
                'label' => __('Testimonial', 'bayone_plg'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Enter testimonial text here.', 'bayone_plg'),
            ]
        );

        $repeater->add_control(
            'author',
            [
                'label' => __('Author', 'bayone_plg'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Author Name', 'bayone_plg'),
            ]
        );

        $repeater->add_control(
            'position',
            [
                'label' => __('Position', 'bayone_plg'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Author Position', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'testimonial_items',
            [
                'label' => __('Testimonial Items', 'bayone_plg'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'icon_image' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(),
                        ],
                        'testimonial' => __('Enter testimonial text here.', 'bayone_plg'),
                        'author' => __('Author Name', 'bayone_plg'),
                        'position' => __('Author Position', 'bayone_plg'),
                    ],
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $title= $settings['title']
        ?>
<!--        p-2 mb-5-->
        <section class="bayone-testimonials">
                <div class="sec-head">
                    <div class="d-flex align-items-center">
                        <div>
                            <h3><?=$title?></h3>
                        </div>
                        <div class="ms-auto">
                            <div class="swiper-button-prev">
                                <span class="pe-7s-angle-left"></span>
                            </div>
                            <div class="swiper-button-next">
                                <span class="pe-7s-angle-right"></span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-9">
                        <div class="testim" data-carousel="swiper" data-items="1" data-loop="true" data-space="30">
                            <div id="content-carousel-container-unq-testim" class="swiper-container"
                                 data-swiper="container">
                                <div class="swiper-wrapper">
                                    <?php
                                    foreach ($settings['testimonial_items'] as $item) :
                                        ?>
                                        <div class="swiper-slide">
                                            <div class="item">
                                                <div class="row">
                                                    <div class="col-md-2">
                                                        <div class="quote-icon icon-img-80 pt-10">
                                                            <img src="<?php echo esc_url($item['icon_image']['url']); ?>" alt="#">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-10">
                                                        <div class="cont">
                                                            <h4 class="fz-24"><?php echo esc_html($item['testimonial']); ?></h4>
                                                            <div class="info mt-30">
                                                                <h5 class="text-u ls1"><?php echo esc_html($item['author']); ?></h5>
                                                                <span class="text-u sub-title"><?php echo esc_html($item['position']); ?></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 d-flex align-items-center justify-content-center">
                        <div class="swiper-pagination"></div>
                    </div>
                </div>
        </section>
        <?php
    }
}