<?php
namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;

if (!defined('ABSPATH')) exit;

class Bayone_Text_Indent extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'bayone-text-text-indent';
    }

    public function get_title()
    {
        return __('Bayone Text Indent', 'bayone_plg');
    }

    public function get_icon()
    {
        return 'eicon-heading';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Text Indent Settings', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Title', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Our capabilities', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'text',
            [
                'label' => __('text', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('All Features', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'subtitle',
            [
                'label' => __('Subtitle', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Who Are We?', 'bayone_plg'),
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__( 'Style Section', 'textdomain' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'column_width',
            [
                'label' => __('Column Width', 'bayone_plg'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 11,
                ],
                'range' => [
                    'min' => 1,
                    'max' => 12,
                    'step' => 1,
                ],
                'description' => __('Choose the width of the left column (out of 12 columns).', 'bayone_plg'),
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'bayone_plg'),
                'selector' => '{{WRAPPER}} .bayone-text-indent h3',
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'bayone_plg'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff', // Default color value
                'selectors' => [
                    '{{WRAPPER}} .bayone-text-indent h3' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'text_typography',
                'label' => __('Text Typography', 'bayone_plg'),
                'selector' => '{{WRAPPER}} .bayone-text-indent p',
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label' => __('Text Color', 'bayone_plg'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ddd', // Default color value
                'selectors' => [
                    '{{WRAPPER}} .bayone-text-indent p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sub_title_typography',
                'label' => __('Sub Title Typography', 'bayone_plg'),
                'selector' => '{{WRAPPER}} .bayone-text-indent .sub-title',
            ]
        );

        $this->add_control(
            'subtitle_color',
            [
                'label' => __('Subtitle Color', 'bayone_plg'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff', // Default color value
                'selectors' => [
                    '{{WRAPPER}} .bayone-text-indent .sub-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'show_subtitle',
            [
                'label' => __('Hide Sub Title', 'bayone_plg'),
                'type' => Controls_Manager::SWITCHER,
                'default' => true,
            ]
        );
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $title = $settings['title'];
        $text = $settings['text'];
        $subtitle = $settings['subtitle'];
        $column_width = $settings['column_width']['size'];
        $show_subtitle = $settings['show_subtitle'];
        $subtitle_classes = '';
        if ($show_subtitle) {
            $subtitle_classes = 'display-md-inline-block';
        }
        ?>
        <section class="bayone-text-indent">
                <div class="row">
                    <div class="col-lg-<?=$column_width?>">
                        <span class="sub-title bord mb-30 <?=$subtitle_classes?>"><?=$subtitle?></span>
                        <h3 class="text-u text-indent ls1"><?=$title?></h3>
                    </div>
                    <?php if($text) : ?>
                        <div class="col-lg-7 offset-lg-5">
                        <div class="text mt-50">
                            <p><?=$text?></p>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
        </section>
        <?php
    }
}
