<?php
namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Utils;

if (!defined('ABSPATH')) exit;

class Bayone_Text_Opacity extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'bayone-text-text-opacity';
    }

    public function get_title()
    {
        return __('Bayone Text Opacity', 'bayone_plg');
    }

    public function get_icon()
    {
        return 'eicon-heading';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Text Opacity Settings', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'heading_text',
            [
                'label' => __('Heading Text', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('This is a heading', 'bayone_plg'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'heading_color',
            [
                'label' => __('Title Color', 'bayone_plg'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff', // Default color value
                'selectors' => [
                    '{{WRAPPER}} .bayone-text-opacity' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'typography',
                'label' => __('Typography', 'bayone_plg'),
                'selector' => '{{WRAPPER}} .bayone-text-opacity',
            ]
        );

        $this->add_control(
            'heading_opacity',
            [
                'label' => __('Heading Opacity', 'bayone_plg'),
                'type' => Controls_Manager::NUMBER,
                'default' => 1,
                'min' => 0,
                'max' => 1,
            ]
        );

        $this->add_responsive_control(
            'alignment',
            [
                'label' => __('Alignment', 'bayone_plg'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'bayone_plg'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'bayone_plg'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'bayone_plg'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .bayone-text-opacity' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $heading_text = $settings['heading_text'];

        ?>
        <div class="bayone-text-opacity" style="opacity: <?=$settings['heading_opacity']?>;">
            <?php echo esc_html($heading_text); ?>
        </div>
        <?php
    }

    /**
     * Render the widget output in the editor.
     *
     * Written as a Backbone JavaScript template and used to generate the live preview.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function content_template()
    {
    }




}