<?php
namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;


if (!defined('ABSPATH')) exit;

class Bayone_Text_Scroll extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'bayone-text-text-scroll-animate';
    }

    public function get_title()
    {
        return __('Bayone Text Scroll', 'bayone_plg');
    }

    public function get_icon()
    {
        return 'eicon-scroll';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    public function get_script_depends() {
        return ['lib-gsap.min','lib-ScrollSmoother.min','lib-ScrollTrigger.min','bayone-text-scroll'];
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Text Scroll Settings', 'bayone_plg'),
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'typography',
                'label' => __('Typography', 'bayone_plg'),
                'selector' => '{{WRAPPER}} .bayone-text-scroll .text-reval h2 ',
            ]
        );

        $this->add_control(
            'heading_color',
            [
                'label' => __('Title Color', 'bayone_plg'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff', // Default color value
                'selectors' => [
                    '{{WRAPPER}} .bayone-text-scroll .text-reval h2 ' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'heading_margin',
            [
                'label' => __('Heading Margin', 'bayone_plg'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .bayone-text-scroll .text-reval h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

    
        $repeater = new \Elementor\Repeater();
    
        $repeater->add_control(
            'text',
            [
                'label' => __('Text', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('We are a creative studio with focus', 'bayone_plg'),
            ]
        );
    
        $this->add_control(
            'text_list',
            [
                'label' => __('Text List', 'bayone_plg'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'text' => __('We are a creative studio with focus', 'bayone_plg'),
                    ],
                ],
                'title_field' => '{{{ text }}}',
            ]
        );
    
        $this->end_controls_section();
    }
    
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="bayone-text-scroll">
            <div class="text-reval">
                <h2>
                    <?php foreach ($settings['text_list'] as $item) : ?>
                        <span class="text"><?php echo esc_html($item['text']); ?></span>
<!--                        <br>-->
                    <?php endforeach; ?>
                </h2>
            </div>
        </div>
        <?php
    }
}