<?php
namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;

if (!defined('ABSPATH')) exit;

class Bayone_Video_Section extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'bayone-video-video-section';
    }

    public function get_title()
    {
        return __('Bayone Video Section', 'bayone_plg');
    }

    public function get_icon()
    {
        return 'eicon-video-camera';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Video Section Settings', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'video_source',
            [
                'label' => __('Video Source', 'bayone_plg'),
                'type' => Controls_Manager::MEDIA,
                'media_type' => 'video',
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'muted',
            [
                'label' => __('Muted', 'bayone_plg'),
                'type' => Controls_Manager::SWITCHER,
                'default' => true,
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => __('Autoplay', 'bayone_plg'),
                'type' => Controls_Manager::SWITCHER,
                'default' => true,
            ]
        );

        $this->add_control(
            'loop',
            [
                'label' => __('loop', 'bayone_plg'),
                'type' => Controls_Manager::SWITCHER,
                'default' => true,
            ]
        );

        $this->add_responsive_control(
            'column_width',
            [
                'label' => __('Column Width', 'bayone_plg'),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 12,
                'step' => 1,
                'default' => 12,
//                'selectors' => [
//                    '{{WRAPPER}} .col-lg-{{SIZE}}' => 'flex-basis: calc(({{SIZE}} / 12) * 100%); max-width: calc(({{SIZE}} / 12) * 100%);',
//                ],
            ]
        );

        $this->add_responsive_control(
            'video_container_height',
            [
                'label' => __('Video Container Height', 'bayone_plg'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px','vh'],
                'default' => [
                    'size' => 450,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .bayone-video-section .video-container' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'video_container_min_height',
            [
                'label' => __('Video Container Min-Height', 'bayone_plg'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px','vh'],
                'default' => [
                    'size' => 80,
                    'unit' => 'vh',
                ],
                'selectors' => [
                    '{{WRAPPER}} .bayone-video-section .video-container' => 'min-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'video_intro_margin',
            [
                'label' => __('Video Intro Margin', 'bayone_plg'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .bayone-video-section .vid-intro' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'alignment',
            [
                'label' => __('Alignment', 'bayone_plg'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'flex-start' => [
                        'title' => __('Left', 'bayone_plg'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'bayone_plg'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'flex-end' => [
                        'title' => __('Right', 'bayone_plg'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .bayone-video-section .alignment' => 'justify-content: {{VALUE}};',
                ],
            ]
        );


        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $autoplay = $settings['autoplay'];
        $loop = $settings['loop'];
        $muted = $settings['muted'];
        $video_source = $settings['video_source']['url'];
        $column_width= $settings['column_width'];
        ?>
            <div class="bayone-video-section">
                <div class="row alignment">
                    <div class="col-lg-<?=$column_width?>">
                        <div class="vid-intro">
                            <div class="video-container">
                                <video <?= ($autoplay) ? "autoplay":"" ?> <?= ($loop) ? "loop":"" ?> <?= ($muted) ? "muted":"" ?>>
                                    <source src="<?=$video_source?>" type="video/mp4">
                                </video>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php
    }
}
