<?php
namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;

if (!defined('ABSPATH')) exit;

class Bayone_Work_Crev extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'bayone-work-work-crev-animate';
    }

    public function get_title()
    {
        return __('Bayone Work Crev', 'bayone_plg');
    }

    public function get_icon()
    {
        return 'eicon-menu-card';
    }

    public function get_script_depends() {
        return [ 'bayone-work-crev'];
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Work Crev Settings', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Title', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Recent Work', 'bayone_plg'),
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'portfolio_item',
            [
                'label' => __( 'Item to display', 'bayone_blg' ),
                'type' => Controls_Manager::NUMBER,
                'default' => '8',
            ]
        );

        $this->add_control(
            'port_order',
            [
                'label' => __( 'Orders', 'bayone_blg' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'DESC' => __( 'Descending', 'bayone_blg' ),
                    'ASC' => __( 'Ascending', 'bayone_blg' ),
                    'rand' => __( 'Random', 'bayone_blg' ),
                ],
                'default' => 'DESC',
            ]
        );

        $this->add_control(
            'selected_terms',
            [
                'label' => __('Select Taxonomy Terms', 'bayone_plg'),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->get_taxonomy_terms(), // Create a method to retrieve taxonomy terms
                'default' => [],
            ]
        );

        $this->add_control(
            'selected_tags',
            [
                'label' => __('Select Tags', 'bayone_plg'),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->get_tag_options(),
                'default' => [],
            ]
        );

        $this->end_controls_section();
    }
    protected function render() {
        $settings = $this->get_settings_for_display();
        $title = $settings['title'];
        $selected_terms = $settings['selected_terms'];
        $selected_tags = $settings['selected_tags'];
        if ($settings['port_order'] != 'rand') {
            $order = 'order';
            $ord_val = $settings['port_order'];
        } else {
            $order = 'orderby';
            $ord_val = 'rand';
        }
        $bayone_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
        $query_args = array(
            'paged' => $bayone_paged,
            'posts_per_page' => $settings['portfolio_item'],
            'post_type' => 'portfolio',
            $order => $ord_val,
        );
        if (!empty($selected_terms)) {
            $query_args['tax_query'] = array(
                array(
                    'taxonomy' => 'portfolio_category',
                    'field' => 'term_id',
                    'terms' => $selected_terms,
                ),
            );
        }
        if (!empty($selected_tags)) {
            $query_args['tax_query'][] = array(
                'taxonomy' => 'porto_tag',
                'field' => 'term_id',
                'terms' => $selected_tags,
            );
        }
        $bayone_work = new \WP_Query($query_args);
        ?>
        <section class="bayone-work-crev section-padding bg-gray text-dark">
            <div class="con">
                <div class="sec-head pb-20 bord-thin-bottom mb-80">
                    <div class="d-flex align-items-center">
                        <div>
                            <h3 class="f-bold text-u"><?=$title?></h3>
                        </div>
                        <div class="ms-auto">
                            <div class="swiper-button-next">
                                <span class="pe-7s-angle-left"></span>
                            </div>
                            <div class="swiper-button-prev">
                                <span class="pe-7s-angle-right"></span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="work-crus">
                    <div class="swiper-wrapper">
                        <?php if ($bayone_work->have_posts()) : while  ($bayone_work->have_posts()) : $bayone_work->the_post(); global $post ; ?>
                            <div class="swiper-slide">
                                <div class="item">
                                    <div class="img">
                                        <img src="<?= esc_url(get_the_post_thumbnail_url()); ?>" alt="">
                                    </div>
                                    <div class="cont">
                                        <div>
                                            <?php
                                            $bayone_work_taxonomy = 'portfolio_category';
                                            $bayone_work_taxs = wp_get_post_terms($post->ID, $bayone_work_taxonomy);
                                            ?>
                                            <?php foreach ($bayone_work_taxs as $bayone_work_tax) : ?>
                                            <span><?= $bayone_work_tax->name ?></span>
                                            <?php endforeach; ?>
                                            <h5><?= get_the_title() ?></h5>
                                        </div>
                                    </div>
                                    <a href="<?= get_the_permalink() ?>" class="link-overlay animsition-link"></a>
                                </div>
                            </div>
                        <?php endwhile;  wp_reset_postdata(); endif; ?>
                    </div>
                </div>
            </div>
        </section>
        <?php
    }

    private function get_taxonomy_terms() {
        $terms = get_terms(array(
            'taxonomy' => 'portfolio_category', // Replace with your actual taxonomy slug
            'hide_empty' => true,
        ));

        $options = [];
        foreach ($terms as $term) {
            $options[$term->term_id] = $term->name;
        }

        return $options;
    }
    private function get_tag_options() {
        $tags = get_terms(array(
            'taxonomy' => 'porto_tag',
            'hide_empty' => true,
        ));

        $options = [];
        foreach ($tags as $tag) {
            $options[$tag->term_id] = $tag->name;
        }

        return $options;
    }


}
