<?php
namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) exit;

class Bayone_Work_Gallery extends Widget_Base
{
    public function get_name()
    {
        return 'bayone-work-work-gallery';
    }

    public function get_script_depends() {
        return [ 'bayone-call-action-slide' ];
    }

    public function get_title()
    {
        return __('Bayone Work Gallery', 'bayone_plg');
    }

    public function get_icon()
    {
        return 'eicon-gallery-masonry';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Work Gallery', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'text',
            [
                'label' => __('Text', 'bayone_plg'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Selected Projects', 'bayone_plg'),
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'portfolio_item',
            [
                'label' => __( 'Item to display', 'bayone_blg' ),
                'type' => Controls_Manager::NUMBER,
                'default' => '8',
            ]
        );

        $this->add_control(
            'port_order',
            [
                'label' => __( 'Orders', 'bayone_blg' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'DESC' => __( 'Descending', 'bayone_blg' ),
                    'ASC' => __( 'Ascending', 'bayone_blg' ),
                    'rand' => __( 'Random', 'bayone_blg' ),
                ],
                'default' => 'DESC',
            ]
        );

        $this->add_control(
            'selected_terms',
            [
                'label' => __('Select Taxonomy Terms', 'bayone_plg'),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->get_taxonomy_terms(), // Create a method to retrieve taxonomy terms
                'default' => [],
            ]
        );


        $this->end_controls_section();

		$this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__( 'Title', 'bayone_plg' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'bayone_plg'),
                'selector' => '{{WRAPPER}} .bayone-work-gallery .marquee-head .main-marq .box .item h2, {{WRAPPER}} .bayone-work-gallery .marquee-head .item h2:after',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'bayone_plg'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bayone-work-gallery .marquee-head .main-marq .box .item h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

		$this->start_controls_section(
			'section_item_title_style',
			[
				'label' => esc_html__( 'Item Title', 'bayone_plg' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'item_title_typography',
                'label' => __('Title Typography', 'bayone_plg'),
                'selector' => '{{WRAPPER}} .bayone-work-gallery .gallery-img .item .info h5',
            ]
        );

        $this->add_control(
            'item_title_color',
            [
                'label' => __('Item Title Color', 'bayone_plg'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bayone-work-gallery .gallery-img .item .info h5' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

		$this->start_controls_section(
			'section_item_cat_style',
			[
				'label' => esc_html__( 'Item Category', 'bayone_plg' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'item_cat_typography',
                'label' => __('Item Category Typography', 'bayone_plg'),
                'selector' => '{{WRAPPER}} .bayone-work-gallery .gallery-img .item span',
            ]
        );

        $this->add_control(
            'item_cat_color',
            [
                'label' => __('Item Category Color', 'bayone_plg'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bayone-work-gallery .gallery-img .item span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $selected_terms = $settings['selected_terms'];
        $text = $settings['text'];
        if ($settings['port_order'] != 'rand') {
            $order = 'order';
            $ord_val = $settings['port_order'];
        } else {
            $order = 'orderby';
            $ord_val = 'rand';
        }
        $bayone_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
        $query_args = array(
            'paged' => $bayone_paged,
            'posts_per_page' => $settings['portfolio_item'],
            'post_type' => 'portfolio',
            $order => $ord_val,
        );
        if (!empty($selected_terms)) {
            $query_args['tax_query'] = array(
                array(
                    'taxonomy' => 'portfolio_category',
                    'field' => 'term_id',
                    'terms' => $selected_terms,
                ),
            );
        }
        $bayone_work = new \WP_Query($query_args);
        ?>
        <section class="bayone-work-gallery section-padding bg-gray text-dark">
            <div class="marquee-head">
                <div class="rest">
                    <div class="row">
                        <div class="col-12">
                            <div class="main-marq">
                                <div class="slide-har st1">
                                    <div class="box non-strok">
                                        <?php for($i=0;$i<=5;$i++) : ?>
                                        <div class="item">
                                            <h2><?=$text?></h2>
                                        </div>
                                        <?php endfor; ?>
                                    </div>
                                    <div class="box non-strok">
                                        <?php for($i=0;$i<=5;$i++) : ?>
                                            <div class="item">
                                                <h2><?=$text?></h2>
                                            </div>
                                        <?php endfor; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="mx-2">
                <div class="container">
                    <div class="row gallery-img">
                <?php $itemCount=1; if ($bayone_work->have_posts()) : while  ($bayone_work->have_posts()) : $bayone_work->the_post(); global $post ; ?>

                    <div class=" <?php if($itemCount==1) echo "col-lg-4 valign"; elseif ($itemCount==2) echo "col-lg-6 offset-lg-2"; elseif ($itemCount==3) echo "col-lg-8 offset-lg-2";elseif ($itemCount==4) echo "col-lg-6";else echo "col-lg-4 offset-lg-2" ?>">
                        <div class="item">
                            <div class="img">
                                <img src="<?= esc_url(get_the_post_thumbnail_url()); ?>" alt="">
                            </div>
                            <div class="info d-flex align-items-center mt-20">
                                <div>
                                    <h5 class="fz-20"><?= get_the_title() ?></h5>
                                </div>
                                <div class="ms-auto">
                                    <?php
                                    $bayone_work_taxonomy = 'portfolio_category';
                                    $bayone_work_taxs = wp_get_post_terms($post->ID, $bayone_work_taxonomy);
                                    ?>
                                    <?php foreach ($bayone_work_taxs as $bayone_work_tax) : ?>
                                        <span class="text-u fz-13"><?= $bayone_work_tax->name ?></span>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                            <a href="<?= get_the_permalink() ?>" class="link-overlay animsition-link"></a>
                        </div>
                    </div>
                <?php if($itemCount==5) $itemCount=0; $itemCount++;  endwhile;  wp_reset_postdata(); endif; ?>
                </div>
                </div>
            </div>
        </section>
        <?php
    }



    private function get_taxonomy_terms() {
        $terms = get_terms(array(
            'taxonomy' => 'portfolio_category', // Replace with your actual taxonomy slug
            'hide_empty' => true,
        ));

        $options = [];
        foreach ($terms as $term) {
            $options[$term->term_id] = $term->name;
        }

        return $options;
    }

}
