<?php
namespace BayonePlugin\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;

if (!defined('ABSPATH')) exit;

class Bayone_Works_Scroll extends Widget_Base
{
    public function get_name()
    {
        return 'bayone-works-works-scroll';
    }

    public function get_script_depends() {
        return [ 'bayone-hscroll' ];
    }

    public function get_title()
    {
        return __('Bayone Works Scroll', 'bayone_plg');
    }


    public function get_icon()
    {
        return 'eicon-gallery-masonry';
    }

    public function get_categories()
    {
        return ['bayone-elements'];
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Work Scroll', 'bayone_plg'),
            ]
        );

        $this->add_control(
            'portfolio_item',
            [
                'label' => __( 'Item to display', 'bayone_blg' ),
                'type' => Controls_Manager::NUMBER,
                'default' => '8',
            ]
        );

        $this->add_control(
            'port_order',
            [
                'label' => __( 'Orders', 'bayone_blg' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'DESC' => __( 'Descending', 'bayone_blg' ),
                    'ASC' => __( 'Ascending', 'bayone_blg' ),
                    'rand' => __( 'Random', 'bayone_blg' ),
                ],
                'default' => 'DESC',
            ]
        );

        $this->add_control(
            'selected_terms',
            [
                'label' => __('Select Taxonomy Terms', 'bayone_plg'),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->get_taxonomy_terms(), // Create a method to retrieve taxonomy terms
                'default' => [],
            ]
        );

        $this->add_control(
            'selected_tags',
            [
                'label' => __('Select Tags', 'bayone_plg'),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->get_tag_options(),
                'default' => [],
            ]
        );


        $this->end_controls_section();
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__( 'Style Section', 'textdomain' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'date_typography',
                'label' => __('Date Typography', 'bayone_plg'),
                'selector' => '{{WRAPPER}} .bayone-works-scroll .cont .date ',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'category_typography',
                'label' => __('Category Typography', 'bayone_plg'),
                'selector' => '{{WRAPPER}} .bayone-works-scroll .cont .category ',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'bayone_plg'),
                'selector' => '{{WRAPPER}} .bayone-works-scroll .cont .title ',
            ]
        );
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $selected_terms = $settings['selected_terms'];
        $selected_tags = $settings['selected_tags'];
        if ($settings['port_order'] != 'rand') {
            $order = 'order';
            $ord_val = $settings['port_order'];
        } else {
            $order = 'orderby';
            $ord_val = 'rand';
        }
        $bayone_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
        $query_args = array(
            'paged' => $bayone_paged,
            'posts_per_page' => $settings['portfolio_item'],
            'post_type' => 'portfolio',
            $order => $ord_val,
        );
        if (!empty($selected_terms)) {
            $query_args['tax_query'] = array(
                array(
                    'taxonomy' => 'portfolio_category',
                    'field' => 'term_id',
                    'terms' => $selected_terms,
                ),
            );
        }
        if (!empty($selected_tags)) {
            $query_args['tax_query'][] = array(
                'taxonomy' => 'porto_tag',
                'field' => 'term_id',
                'terms' => $selected_tags,
            );
        }
        $bayone_work = new \WP_Query($query_args);
        ?>
        <section class="bayone-works-scroll thecontainer ontop sub-bg">
            <?php $itemCount=1; if ($bayone_work->have_posts()) : while  ($bayone_work->have_posts()) : $bayone_work->the_post(); global $post ; ?>
                <div class="panel">
                <div class="item">
                    <div class="img">
                        <img src="<?= esc_url(get_the_post_thumbnail_url()); ?>" alt="">
                    </div>
                    <div class="cont d-flex align-items-center">
                        <div>
                            <?php
                            $bayone_work_taxonomy = 'portfolio_category';
                            $bayone_work_taxs = wp_get_post_terms($post->ID, $bayone_work_taxonomy);
                            ?>
                            <?php foreach ($bayone_work_taxs as $bayone_work_tax) : ?>
                                <span class="text-u fz-13 category"><?= $bayone_work_tax->name ?></span>
                            <?php endforeach; ?>
                            <h5 class="title"><?= get_the_title() ?></h5>
                        </div>
                        <div class="ms-auto">
                            <h6 class="date"><?php echo get_the_date('Y'); ?></h6>
                        </div>
                    </div>
                    <a href="<?= get_the_permalink() ?>" class="link-overlay animsition-link"></a>
                </div>
            </div>
            <?php if($itemCount==5) $itemCount=0; $itemCount++;  endwhile;  wp_reset_postdata(); endif; ?>
        </section>
        <?php
    }



    private function get_taxonomy_terms() {
        $terms = get_terms(array(
            'taxonomy' => 'portfolio_category',
            'hide_empty' => true,
        ));

        $options = [];
        foreach ($terms as $term) {
            $options[$term->term_id] = $term->name;
        }

        return $options;
    }

    private function get_tag_options() {
        $tags = get_terms(array(
            'taxonomy' => 'porto_tag',
            'hide_empty' => true,
        ));

        $options = [];
        foreach ($tags as $tag) {
            $options[$tag->term_id] = $tag->name;
        }

        return $options;
    }

}
