<?php
namespace Elementor;

class Bayone_Extend_section {

    public function __construct() {

        /**
         * Section Controls
         */
        add_action( 'elementor/element/section/section_advanced/after_section_end', [$this, 'register_section_controls'] );
    }

    /**
     * Section Controls
     */
    public function register_section_controls( Controls_Stack $element ) {
        $element->start_controls_section(
            'bayone_onepagescroll_section',
            [
                'label'         => esc_html__( 'Bayone Sticky Settings', 'bayone_plg' ),
                'tab'           => Controls_Manager::TAB_ADVANCED,
                'hide_in_inner' => false,
            ]
        );
        // $element->add_control(
        //     'bayone_is_sticky',
        //     [
        //         'label'                 => esc_html__( 'Enable Sticky', 'bayone_plg' ),
        //         'type'                  => Controls_Manager::SWITCHER,
        //         'frontend_available'    => true,
        //         'return_value'          => 'section',
        //         'prefix_class'          => 'bayone-sticky-', 
        //     ]
        // );

		$element->add_control(
			'sticky',
			[
				'label' => __( 'Sticky', 'bayone_plg' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'' => __( 'None', 'bayone_plg' ),
					'top' => __( 'Top', 'bayone_plg' ),
					'bottom' => __( 'Bottom', 'bayone_plg' ),
				],
				'separator' => 'before',
				'render_type' => 'none',
				'frontend_available' => true,
				'prefix_class'          => 'bayone-sticky-',
			]
		);

        $element->add_control(
            'sticky_background',
            [
                'label'     => __( 'Background Scroll', 'bayone_plg' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}.elementor-section.is-stuck' => 'background: {{VALUE}};',
                ],
                'condition' => [
                    'sticky' => 'top',
                ],
            ]
        );

		$element->add_control(
			'bayone_bg_blur',
			[
				'label' => esc_html__('Background Blur', 'bayone_plg'),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 150,
					],
				],
				'selectors' => [
					'{{WRAPPER}}.elementor-section' => '    backdrop-filter: blur({{SIZE}}px);',
				],
			]
		);

        // $element->add_control(
        //     'sticky_background4',
        //     [
        //         'label'     => __( 'Background Scroll', 'bayone_plg' ),
        //         'type'      => Controls_Manager::COLOR,
        //         'selectors' => [
        //             '{{WRAPPER}}.elementor-section' => 'background: {{VALUE}};',
        //             '{{WRAPPER}}.elementor-section' => 'background: linear-gradient( #12c2e9, #c471ed, #f64f59);',
        //         ],
        //         'condition' => [
        //             'sticky' => 'top',
        //         ],
        //     ]
        // );
        
        $element->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'scroll_box_shadow',
                'label'     => __( 'Scroll Shadow', 'bayone_plg' ),
                'selector' => '{{WRAPPER}} .elementor-section.is-stuck',
            ]
        );


        $element->add_responsive_control(
            'offset_space',
            [
                'label' => __( 'Offset', 'bayone_plg' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}}.is-stuck' => 'top: {{SIZE}}{{UNIT}};',
                    '.admin-bar {{WRAPPER}}.is-stuck' => 'top: calc({{SIZE}}{{UNIT}} + 32px);', 
                ],
                'condition' => [
                    'sticky' => 'top',
                ],
            ]
        );

        $element->add_control(
            'separator_panel_style',
            [
                'type' => Controls_Manager::DIVIDER,
                'style' => 'thick',
            ]
        );

        $element->add_control(
            'enable_gradient',
            [
                'label' => __( 'Enable Gradient (3rd)', 'bayone_plg' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'bayone_plg' ),
                'label_off' => __( 'No', 'bayone_plg' ),
                'return_value' => 'yes',
                'default' => false,
            ]
        );

        $element->add_control(
            'color',
            [
                'label' => _x( 'Gradient Color', 'Background Control', 'bayone_plg' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'title' => _x( 'Background Color', 'Background Control', 'bayone_plg' ),
                'condition' => [
                    'enable_gradient' => [ 'yes'],
                ],
            ]
        );


        $element->add_control(
            'color_stop', 
            [
                'label' => _x( 'Location', 'Background Control', 'bayone_plg' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ '%' ],
                'default' => [
                    'unit' => '%',
                    'size' => 0,
                ],
                'render_type' => 'ui',
                'condition' => [
                    'enable_gradient' => [ 'yes'],
                ],
                'of_type' => 'gradient',
            ]
        );
        $element->add_control(
            'color_a',
            [
                'label' => _x( 'Second Color', 'Background Control', 'bayone_plg' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#f2295b',
                'render_type' => 'ui',
                'condition' => [
                    'enable_gradient' => [ 'yes'],
                ],
                'of_type' => 'gradient',
            ]
        );

        $element->add_control(
            'color_a_stop', 
            [
                'label' => _x( 'Location', 'Background Control', 'bayone_plg' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ '%' ],
                'default' => [
                    'unit' => '%',
                    'size' => 100,
                ],
                'render_type' => 'ui',
                'condition' => [
                    'enable_gradient' => [ 'yes'],
                ],
                'of_type' => 'gradient',
            ]
        );

        $element->add_control(
            'color_b',
            [
                'label' => _x( 'Second Color', 'Background Control', 'bayone_plg' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#f2295b',
                'render_type' => 'ui',
                'condition' => [
                    'enable_gradient' => [ 'yes'],
                ],
                'of_type' => 'gradient',
            ]
        );

        $element->add_control(
            'color_b_stop', 
            [
                'label' => _x( 'Location', 'Background Control', 'bayone_plg' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ '%' ],
                'default' => [
                    'unit' => '%',
                    'size' => 100,
                ],
                'render_type' => 'ui',
                'condition' => [
                    'enable_gradient' => [ 'yes'],
                ],
                'of_type' => 'gradient',
            ]
        );

        $element->add_control(
            'gradient_type', 
            [
                'label' => _x( 'Type', 'Background Control', 'bayone_plg' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'linear' => _x( 'Linear', 'Background Control', 'bayone_plg' ),
                    'radial' => _x( 'Radial', 'Background Control', 'bayone_plg' ),
                ],
                'default' => 'linear',
                'render_type' => 'ui',
                'condition' => [
                    'enable_gradient' => [ 'yes'],
                ],
                'of_type' => 'gradient',
            ]
        );

        $element->add_control(
            'gradient_angle', 
            [
                'label' => _x( 'Angle', 'Background Control', 'bayone_plg' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'deg' ],
                'default' => [
                    'unit' => 'deg',
                    'size' => 180,
                ],
                'range' => [
                    'deg' => [
                        'step' => 10,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}}.elementor-section' => 'background: linear-gradient({{SIZE}}{{UNIT}}, {{color.VALUE}} {{color_stop.SIZE}}{{color_stop.UNIT}},{{color_a.VALUE}} {{color_a_stop.SIZE}}{{color_a_stop.UNIT}}, {{color_b.VALUE}} {{color_b_stop.SIZE}}{{color_b_stop.UNIT}});',
                ],

                'condition' => [
                    'enable_gradient' => [ 'yes'],
                    'gradient_type' => 'linear',
                ],
                'of_type' => 'gradient',
            ]
        );


        $element->end_controls_section();

        $element->start_controls_section(
            'bayone_header_absolute_section',
            [
                'label'         => esc_html__( 'Geekfolio Header Absolute', 'bayone_plg' ),
                'tab'           => Controls_Manager::TAB_ADVANCED,
                'hide_in_inner' => false,
            ]
        );

		$element->add_control(
			'enable_header_absolute',
			[
				'label' => __( 'Enable Header Absolute', 'bayone_plg' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'on' => __( 'On', 'bayone_plg' ),
					'off' => __( 'Off', 'bayone_plg' ),
				],
				'separator' => 'before',
                'default' => 'off',
				'render_type' => 'off',
				'frontend_available' => true,
				'prefix_class'          => 'bayone-header-absolute-',
			]
		);

        $element->end_controls_section();
    }
}
new Bayone_Extend_section();

class Bayone_Page_Controls {

    public function __construct() {

        /**
         * Section Controls
         */
        add_action( 'elementor/documents/register_controls', [$this, 'register_page_controls'] );
    }

    /**
     * Section Controls
     */
    public function register_page_controls( $element ) {
        
        $element->start_controls_section(
            'bayone_page_lines',
            [
                'label'         => esc_html__( 'Bayone Page Lines', 'newzin_plg' ),
                'tab'           => Controls_Manager::TAB_STYLE,
                'hide_in_inner' => true,
            ]
        );

        $element->add_control(
			'bayone_enable_page_lines',
			[
				'label' => __( 'Enable Page Lines', 'bayone_plg' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'on' => __( 'On', 'bayone_plg' ),
					'off' => __( 'Off', 'bayone_plg' ),
				],
				'separator' => 'before',
                'default' => 'off',
				'render_type' => 'off',
				'frontend_available' => true,
				'prefix_class' => 'bayone-page-lines-',
			]
		);

        $element->end_controls_section();

    }
}
new Bayone_Page_Controls();
?>