
!(function ($) {


    // slider
    function tcgDynamicSlider($scope, $) {
        $scope.find('.tcg-dynamic-slider').each(function () {

            // slider settings
            let tcgDynamicSliderSettings = $(this).data('tcg-dynamic-slider');

            let swiper = new Swiper();

            // avoid controlls apply to other sliders in the same page
            let tcgDynamicSliderId = $(this).attr('id');
            let swiperContainer = $(`#${tcgDynamicSliderId} .swiper-container`).get(0);
            let nextArrow = $(`#${tcgDynamicSliderId} .swiper-button-next`).get(0);
            let preletrow = $(`#${tcgDynamicSliderId} .swiper-button-prev`).get(0);
            let pagination = $(`#${tcgDynamicSliderId} .swiper-pagination`).get(0);
            let scrollbar = $(`#${tcgDynamicSliderId} .swiper-scrollbar`).get(0);

            // Slider Area Element Animation
            let $this = $(this),
                $singleSlideElem = $this.find('.tcg-dynamic-slide .elementor-element[data-settings*="animation"], .tcg-dynamic-slide .elementor-element[data-settings*="_animation"]');
                
            function slideElemAnimation() {
                $singleSlideElem.each(function () {
                    let $this = $(this);
                    let $thisSetting = $this.data('settings') ? $this.data('settings') : '';
                    let $animationName = $thisSetting._animation ? $thisSetting._animation : $thisSetting.animation;
                    if ($(window).width() < 1024 && $(window).width() > 767 && ($thisSetting.animation_tablet || $thisSetting._animation_tablet)) {
                        $animationName = $thisSetting._animation_tablet ? $thisSetting._animation_tablet : $thisSetting.animation_tablet;
                    } else if ($(window).width() < 1024 && $(window).width() < 767 && ($thisSetting.animation_mobile || $thisSetting._animation_mobile)) {
                        $animationName = $thisSetting._animation_mobile ? $thisSetting._animation_mobile : $thisSetting.animation_mobile;
                    }
                    let $animationDelay = $thisSetting._animation_delay ? $thisSetting._animation_delay : $thisSetting.animation_delay;
                    $this.removeClass('animated ' + $animationName).addClass('elementor-invisible');
                    if ($this.closest('.swiper-slide').hasClass('swiper-slide-active')) {
                        setTimeout((() => {
                            $this.removeClass('elementor-invisible').addClass('animated ' + $animationName);
                        }
                        ), $animationDelay)
                    }
                });
            }

            // fix swiper vertical slider height bug
            function setSlideHeight(that) {
                if (tcgDynamicSliderSettings.autoHeight === 'true' && tcgDynamicSliderSettings.direction !== 'vertical') {
                    // do nothing
                    return;
                } else {
                    $('.tcg-dynamic-slider .swiper-slide').css({ height: 'auto' });
                    let currentSlide = that.activeIndex;
                    let newHeight = $(that.slides[currentSlide]).height();
                    $('#'+tcgDynamicSliderId).find('.swiper-wrapper, .swiper-slide').each(function () {
                        $(this).css({ height: newHeight });
                    });
                    that.update();
                }
            }

            // set slidesPerView to 1
            function oneSlideView(breakpoints) {
                for (let key in breakpoints) {
                    if (breakpoints.hasOwnProperty(key)) {
                        breakpoints[key].slidesPerView = 1;
                    }
                }
                return breakpoints;
            }

            if (tcgDynamicSliderSettings.direction === 'vertical' && tcgDynamicSliderSettings.effect === 'parallax') {
                tcgDynamicSliderSettings.autoHeight = 'true';
            }

            //slider data
            let tcgDynamicSliderOptions = {
                loop: (tcgDynamicSliderSettings.loop === 'true'),
                effect: tcgDynamicSliderSettings.effect,
                speed: tcgDynamicSliderSettings.speed,
                direction: tcgDynamicSliderSettings.direction,
                oneWayMovement: (tcgDynamicSliderSettings.oneWayMovement === 'true'),
                centeredSlides: (tcgDynamicSliderSettings.centeredSlides === 'true'),
                autoHeight: (tcgDynamicSliderSettings.autoHeight === 'true'),
                mousewheel: {
                    enabled: (tcgDynamicSliderSettings.mousewheel === 'true'),
                },
                keyboard: {
                    enabled: (tcgDynamicSliderSettings.keyboard === 'true'),
                },
                navigation: {
                    nextEl: nextArrow,
                    prevEl: preletrow,
                },
                pagination: {
                    el: pagination,
                    type: tcgDynamicSliderSettings.paginationType,
                    clickable: true
                },
                scrollbar: {
                    el: scrollbar,
                    draggable: true,
                    snapOnRelease: true,
                },
                on: {
                    init: function () {
                        setSlideHeight(this);
                        slideElemAnimation();
                    },
                    slideChangeTransitionStart: function () {
                        slideElemAnimation();
                    },
                    resize: function () {
                        setSlideHeight(this);
                        this.update();
                    },
                },
                observer: true,
                observeParents: true,
            }

            // check parallax effect or else
            if (tcgDynamicSliderSettings.effect == 'parallax') {
                tcgDynamicSliderOptions['parallax'] = true;
                tcgDynamicSliderOptions['on'] = {
                    init: function () {
                        setSlideHeight(this);
                        let swiper = this;
                        for (let i = 0; i < swiper.slides.length; i++) {
                            let dim = tcgDynamicSliderSettings.direction === 'vertical' ? swiper.height : swiper.width;
                            $(swiper.slides[i]).find('.tcg-dynamic-slide').attr({ 'data-swiper-parallax': 0.75 * dim }).addClass('tcg-dynamic-slider-parallex');
                        }
                        slideElemAnimation();
                    },
                    slideChangeTransitionStart: function () {
                        slideElemAnimation();
                    },
                    scrollbarDragMove: function () {
                        slideElemAnimation();
                    },
                    resize: function () {
                        setSlideHeight(this);
                        this.update();
                    },
                };
                tcgDynamicSliderOptions['breakpoints'] = oneSlideView(tcgDynamicSliderSettings.breakpoints);
            } else if (tcgDynamicSliderSettings.effect !== 'slide' && tcgDynamicSliderSettings.effect !== 'coverflow' && tcgDynamicSliderSettings.effect !== 'cards') {
                tcgDynamicSliderOptions['breakpoints'] = oneSlideView(tcgDynamicSliderSettings.breakpoints);
            } else {
                tcgDynamicSliderOptions['breakpoints'] = tcgDynamicSliderSettings.breakpoints;
            }

            // check for autoplay
            if (tcgDynamicSliderSettings.autoplay) {
                tcgDynamicSliderOptions['autoplay'] = {
                    delay: tcgDynamicSliderSettings.autoplay.delay,
                    reverseDirection: (tcgDynamicSliderSettings.autoplay.reverseDirection === 'true')
                }
            }

            // check for cards effect
            if (tcgDynamicSliderSettings.autoplay) {
                tcgDynamicSliderOptions['autoplay'] = {
                    delay: tcgDynamicSliderSettings.autoplay.delay,
                    reverseDirection: (tcgDynamicSliderSettings.autoplay.reverseDirection === 'true'),
                    disableOnInteraction: (tcgDynamicSliderSettings.disableOnInteraction === 'true'),
                }
            }

            if (tcgDynamicSliderSettings.effect === 'cards') {
                tcgDynamicSliderOptions['cardsEffect'] = {
                    rotate: true,
                    slideShadows: false,
                    perSlideOffset: tcgDynamicSliderSettings.cardsOffset,
                    perSlideRotate: tcgDynamicSliderSettings.cardsRotate
                }
            }

            swiper = new Swiper(swiperContainer, tcgDynamicSliderOptions);

        });

    }

    jQuery(window).on('elementor/frontend/init', function () {

        elementorFrontend.hooks.addAction('frontend/element_ready/tcg-dynamic-slider.default', tcgDynamicSlider);

    });


})(jQuery); 
