<?php

namespace ThemescampPlugin\Elementor\Elements\Widgets;

use Elementor\Group_Control_Typography;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\repeater;
use Elementor\Frontend;
use Elementor\Icons_Manager;
use Elementor\Core\Schemes;
use Elementor\Group_Control_Image_Size;
use Elementor\Scheme_Base;
use Elementor\Group_Control_Text_Shadow;
use ThemescampPlugin\Elementor\Controls\Helper as ControlsHelper;


if (!defined('ABSPATH')) exit; // Exit if accessed directly



/**
 * @since 1.1.0
 */
class TCG_Dynamic_Query extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve icon list widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'tcg-dynamic-query';
    }

    /**
     * Get widget title.
     *
     * Retrieve icon list widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return esc_html__('TC Dynamic Query', 'themescamp-plugin');
    }

    /**
     * Get widget icon.
     *
     * Retrieve icon list widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'eicon-document-file';
    }

    /**
     * Get widget keywords.
     *
     * Retrieve the list of keywords the widget belongs to.
     *
     * @since 2.1.0
     * @access public
     *
     * @return array Widget keywords.
     */
    public function get_keywords()
    {
        return ['posts', 'blogs', 'portfolio'];
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['themescamp-elements'];
    }

    /**
     * Register icon list widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 3.1.0
     * @access protected
     */

    protected function register_controls()
    {

        $post_types = ControlsHelper::get_post_types();
        $post_types['by_id'] = __('Manual Selection', 'themescamp-plugin');

        $taxonomies = get_taxonomies([], 'objects');

        $this->start_controls_section(
            'tcg_section_post_layout',
            [
                'label' => __('Layout', 'themescamp-plugin'),
            ]
        );

        $this->add_control(
            'tcg_select_block',
            [
                'label' => esc_html__('Select Block', 'themescamp-plugin'),
                'type' => 'tcg-select2',
                'multiple' => false,
                'label_block' => true,
                'source_name' => 'block',
                'source_type' => 'tcg_teb',
                'meta_query' => [
                    [
                        'key' => 'template_type',
                        'value' => 'block',
                        'compare' => '='
                    ]
                ]
            ]
        );

        $this->add_control(
            'edit_block',
            [
                'label' => esc_html__('Edit Block', 'themescamp-plugin'),
                'type' => \Elementor\Controls_Manager::BUTTON,
                'separator' => 'before',
                'button_type' => 'success',
                'text' => esc_html__('Edit', 'themescamp-plugin'),
                'event' => 'tcgDynamicQueryEditor',
                'condition' => [
                    'tcg_select_block!' => '',
                ]
            ]
        );

        $this->add_control(
            'add_block',
            [
                'label' => esc_html__('Add Block', 'themescamp-plugin'),
                'type' => \Elementor\Controls_Manager::BUTTON,
                'button_type' => 'success',
                'text' => esc_html__('Add Block', 'themescamp-plugin'),
                'event' => 'tcgAddDynamicBlock',
            ]
        );

        $this->add_responsive_control(
            'columns',
            [
                'label' => __('Columns', 'themescamp-plugin'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '12' => '1 Column',
                    '6' => '2 Column',
                    '4' => '3 Column',
                    '3' => '4 Column',
                    '2' => '6 Column',
                ],
                'separator' => 'before',
                'devices' => ['desktop', 'tablet', 'mobile'],
                'desktop_default' => '4',
                'tablet_default' => '6',
                'mobile_default' => '12',
                'default' => '4',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'tcg_section_post__filters',
            [
                'label' => __('Query', 'themescamp-plugin'),
            ]
        );

        $this->add_control(
            'post_type',
            [
                'label' => __('Source', 'themescamp-plugin'),
                'type' => Controls_Manager::SELECT,
                'options' => $post_types,
                'default' => key($post_types),
            ]
        );

        $this->add_control(
            'tcg_global_dynamic_source_warning_text',
            [
                'type' => Controls_Manager::RAW_HTML,
                'raw' => __('This option will only affect in <strong>Archive page of Elementor Theme Builder</strong> dynamically.', 'themescamp-plugin'),
                'content_classes' => 'tcg-warning',
                'condition' => [
                    'post_type' => 'source_dynamic',
                ],
            ]
        );

        $this->add_control(
            'posts_ids',
            [
                'label' => __('Search & Select', 'themescamp-plugin'),
                'type' => 'tcg-select2',
                'options' => ControlsHelper::get_post_list(),
                'label_block' => true,
                'multiple'    => true,
                'source_name' => 'post_type',
                'source_type' => 'any',
                'condition' => [
                    'post_type' => 'by_id',
                ],
            ]
        );

        $this->add_control(
            'authors',
            [
                'label' => __('Author', 'themescamp-plugin'),
                'label_block' => true,
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'default' => [],
                'options' => ControlsHelper::get_authors_list(),
                'condition' => [
                    'post_type!' => ['by_id', 'source_dynamic'],
                ],
            ]
        );

        foreach ($taxonomies as $taxonomy => $object) {
            if (!isset($object->object_type[0]) || !in_array($object->object_type[0], array_keys($post_types))) {
                continue;
            }

            $this->add_control(
                $taxonomy . '_ids',
                [
                    'label' => $object->label,
                    'type' => 'tcg-select2',
                    'label_block' => true,
                    'multiple' => true,
                    'source_name' => 'taxonomy',
                    'source_type' => $taxonomy,
                    'condition' => [
                        'post_type' => $object->object_type,
                    ],
                ]
            );
        }

        $this->add_control(
            'post__not_in',
            [
                'label'       => __('Exclude', 'themescamp-plugin'),
                'type'        => 'tcg-select2',
                'label_block' => true,
                'multiple'    => true,
                'source_name' => 'post_type',
                'source_type' => 'any',
                'condition'   => [
                    'post_type!' => ['by_id', 'source_dynamic'],
                ],
            ]
        );

        $this->add_control(
            'posts_per_page',
            [
                'label' => __('Posts Per Page', 'themescamp-plugin'),
                'type' => Controls_Manager::NUMBER,
                'default' => '4',
                'min' => '1',
            ]
        );

		$this->add_control(
			'pagination',
			[
				'label' => esc_html__( 'Pagination', 'themescamp-core' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => false,
                'return' => 'yes'
			]
		);

        $this->add_control(
            'offset',
            [
                'label' => __('Offset', 'themescamp-plugin'),
                'type' => Controls_Manager::NUMBER,
                'default' => '0',
                'condition' => [
                    'orderby!' => 'rand',
                    'pagination!' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'orderby',
            [
                'label' => __('Order By', 'themescamp-plugin'),
                'type' => Controls_Manager::SELECT,
                'options' => ControlsHelper::get_post_orderby_options(),
                'default' => 'date',

            ]
        );

        $this->add_control(
            'order',
            [
                'label' => __('Order', 'themescamp-plugin'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'asc' => 'Ascending',
                    'desc' => 'Descending',
                ],
                'default' => 'desc',

            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'posts_style',
            [
                'label' => esc_html__('Posts Style', 'themescamp-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'space_between',
            [
                'label' => esc_html__('Space Between Posts', 'themescamp-core'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'unit' => '%',
                ],
                'tablet_default' => [
                    'unit' => '%',
                ],
                'mobile_default' => [
                    'unit' => '%',
                ],
                'size_units' => ['px', '%', 'em', 'rem', 'vw', 'custom'],
                'range' => [
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-widget-container .row > div:not(:last-child)' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings();
        $settings = ControlsHelper::fix_old_query($settings);
        $args = ControlsHelper::get_query_args($settings);
        $args = ControlsHelper::get_dynamic_args($settings, $args);
        $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
        $query = new \WP_Query($args);

        $columns_tablet = isset($settings['columns_tablet']) ? $settings['columns_tablet'] : 6;
        $columns_mobile = isset($settings['columns_mobile']) ? $settings['columns_mobile'] : 12;
?>
        <div class="tcg-dynamic-query">
            <div class="row">
                <?php
                if ($query->have_posts()) {
                    while ($query->have_posts()) {
                        $query->the_post(); ?>
                        <div class="col-lg-<?php echo esc_attr($settings['columns']); ?> col-md-<?php echo esc_attr($columns_tablet); ?> col-<?php echo esc_attr($columns_mobile); ?>">
                            <?php
                            $frontend = new \Elementor\Frontend();
                            $block_ID  = $settings['tcg_select_block'];
                            echo $frontend->get_builder_content_for_display($block_ID); ?>
                        </div>
                    <?php }; wp_reset_postdata();
                    if($settings['pagination'] == 'yes'): ?>
                        <div class="pagination">
                            <?php
                            $total_pages = $query->max_num_pages;
                            if ($total_pages > 1) {
                                for ($i = 1; $i <= $total_pages; $i++) {
                                    echo '<a href="' . esc_url(get_pagenum_link($i)) . '" ' . ($i == $paged ? 'class="current-page"' : '') . '>' . $i . '</a>';
                                }
                            }
                            ?>
                        </div>
                    <?php endif;
                } else {
                    _e('<p class="no-posts-found">No posts found!</p>', 'themescamp-plugin');
                } ?>
            </div>
        </div>
<?php
    }
}
