<?php
namespace ThemescampPlugin\Elementor\Elements\Widgets;

use Elementor\Widget_Image;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class TCG_Post_Image extends Widget_Image{


	public function get_name() {
		// `theme` prefix is to avoid conflicts with a dynamic-tag with same name.
		return 'tcg-post-featured-image';
	}

	public function get_title() {
		return esc_html__( 'TC Post Image', 'themescamp-core' );
	}

	public function get_icon() {
		return 'eicon-featured-image';
	}

	public function get_categories() {
		return [ 'themescamp-elements' ];
	}

	public function get_keywords() {
		return [ 'image', 'featured', 'thumbnail' ];
	}

	public function get_inline_css_depends() {
		return [
			[
				'name' => 'image',
				'is_core_dependency' => true,
			],
		];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends()
	{
		return ['post-image'];
	}


    protected function register_controls() {
        parent::register_controls();

        $this->update_control(
            'link_to',
            [
                'options' => [
					'none' => esc_html__( 'None', 'elementor' ),
					'file' => esc_html__( 'Media File', 'elementor' ),
					'custom' => esc_html__( 'Custom URL', 'elementor' ),
					'post-url' => esc_html__( 'Post URL', 'elementor' ),
				],
            ]
        );
        
        // Hide the default image control
        $this->update_control(
            'image',
            [
                'type' => \Elementor\Controls_Manager::HIDDEN,
            ]
        );

        $this->start_controls_section(
            'image_hover_section',
            [
                'label' => __('Image Hover', 'themescamp-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'image_hover_overlay',
            [
                'label' => esc_html__('Hover Overlay', 'themescamp-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'themescamp-core'),
                'label_off' => esc_html__('Hide', 'themescamp-core'),
                'return_value' => 'yes',
                'default' => 'no',
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'image_hover_overlay_selector',
            [
                'label' => esc_html__( 'Choose Selector', 'themescamp-plugin' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'image',
                'options' => [
                    'image' => esc_html__( 'Image', 'themescamp-plugin' ),
                    'container'  => esc_html__( 'Parent Container', 'themescamp-plugin' ),
                ],
            ]
        );

        $this->add_control(
            'image_hover_overlay_index',
            [
                'label' => esc_html__( 'Overlay z-index', 'themescamp-elements' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .tcg-post-image::after' => 'z-index: {{SIZE}};',
                ],
                'condition' => [
                    'image_hover_overlay' => 'yes'
                ]
            ]
        );

        $this->add_responsive_control(
            'image_hover_overlay_width',
            [
                'label' => esc_html__( 'Width', 'themescamp-plugin' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 100,
                ],
                'selectors' => [
                    '{{WRAPPER}} .tcg-post-image::after' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'image_hover_overlay' => 'yes'
                ]
            ]
        );

        $this->add_responsive_control(
            'image_hover_overlay_height',
            [
                'label' => esc_html__( 'Height', 'themescamp-plugin' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 100,
                ],
                'selectors' => [
                    '{{WRAPPER}} .tcg-post-image::after' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'image_hover_overlay' => 'yes'
                ]
            ]
        );

        $this->add_responsive_control(
            'image_hover_overlay_border_radius',
            [
                'label' => esc_html__('Border Radius', 'themescamp-elements'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .tcg-post-image::after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'image_hover_overlay' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'image_hover_overlay_transition',
            [
                'label' => esc_html__( 'Transition', 'themescamp-elements' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 1,
                        'min' => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'default' => [
                    'size' => 0.3,
                ],
                'selectors' => [
                    '{{WRAPPER}} .tcg-post-image::after' => 'transition: all {{SIZE}}s ease;',
                ],
            ]
        );

        $this->start_controls_tabs(
            'image_hover_overlay_tabs',
        );

        $this->start_controls_tab(
            'image_hover_overlay_normal_tab',
            [
                'label'   => esc_html__( 'Normal', 'themescamp-plugin' ),
                'condition' => [
                    'image_hover_overlay' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'image_hover_overlay_offset_orientation_h',
            [
                'label' => esc_html__( 'Horizontal Orientation', 'themescamp-elements' ),
                'type' => Controls_Manager::CHOOSE,
                'toggle' => false,
                'default' => 'start',
                'options' => [
                    'start' => [
                        'title' => esc_html__( 'Start', 'themescamp-elements' ),
                        'icon' => 'eicon-h-align-left',
                    ],
                    'end' => [
                        'title' => esc_html__( 'End', 'themescamp-elements' ),
                        'icon' => 'eicon-h-align-right',
                    ],
                ],
                'condition' => [
                    'image_hover_overlay' => 'yes'
                ],
            ]
        );
        $this->add_responsive_control(
            'image_hover_overlay_offset_x',
            [
                'label' => esc_html__( 'Offset', 'themescamp-elements' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => -200,
                        'max' => 200,
                    ],
                    'vw' => [
                        'min' => -200,
                        'max' => 200,
                    ],
                    'vh' => [
                        'min' => -200,
                        'max' => 200,
                    ],
                ],
                'default' => [
                    'size' => 0,
                ],
                'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'vh', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .tcg-post-image::after' => 'left: {{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'image_hover_overlay_offset_orientation_h' => 'start',
                    'image_hover_overlay' => 'yes'
                ],
            ]
        );
        $this->add_responsive_control(
            'image_hover_overlay_offset_x_end',
            [
                'label' => esc_html__( 'Offset', 'themescamp-elements' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => -200,
                        'max' => 200,
                    ],
                    'vw' => [
                        'min' => -200,
                        'max' => 200,
                    ],
                    'vh' => [
                        'min' => -200,
                        'max' => 200,
                    ],
                ],
                'default' => [
                    'size' => 0,
                ],
                'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'vh', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .tcg-post-image::after' => 'right: {{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'image_hover_overlay_offset_orientation_h' => 'end',
                    'image_hover_overlay' => 'yes'
                ],
            ]
        );
        $this->add_control(
            'image_hover_overlay_offset_orientation_v',
            [
                'label' => esc_html__( 'Vertical Orientation', 'themescamp-elements' ),
                'type' => Controls_Manager::CHOOSE,
                'toggle' => false,
                'default' => 'start',
                'options' => [
                    'start' => [
                        'title' => esc_html__( 'Top', 'themescamp-elements' ),
                        'icon' => 'eicon-v-align-top',
                    ],
                    'end' => [
                        'title' => esc_html__( 'Bottom', 'themescamp-elements' ),
                        'icon' => 'eicon-v-align-bottom',
                    ],
                ],
                'condition' => [
                    'image_hover_overlay' => 'yes'
                ]
            ]
        );
        $this->add_responsive_control(
            'image_hover_overlay_offset_y',
            [
                'label' => esc_html__( 'Offset', 'themescamp-elements' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => -200,
                        'max' => 200,
                    ],
                    'vh' => [
                        'min' => -200,
                        'max' => 200,
                    ],
                    'vw' => [
                        'min' => -200,
                        'max' => 200,
                    ],
                ],
                'size_units' => [ 'px', '%', 'em', 'rem', 'vh', 'vw', 'custom' ],
                'default' => [
                    'size' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .tcg-post-image::after' => 'top: {{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'image_hover_overlay_offset_orientation_v' => 'start',
                    'image_hover_overlay' => 'yes'
                ],
            ]
        );
        $this->add_responsive_control(
            'image_hover_overlay_offset_y_end',
            [
                'label' => esc_html__( 'Offset', 'themescamp-elements' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => -200,
                        'max' => 200,
                    ],
                    'vh' => [
                        'min' => -200,
                        'max' => 200,
                    ],
                    'vw' => [
                        'min' => -200,
                        'max' => 200,
                    ],
                ],
                'size_units' => [ 'px', '%', 'em', 'rem', 'vh', 'vw', 'custom' ],
                'default' => [
                    'size' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .tcg-post-image::after' => 'bottom: {{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'image_hover_overlay_offset_orientation_v' => 'end',
                    'image_hover_overlay' => 'yes'
                ],
            ]
        );

        $this->add_control(
            'image_hover_overlay_display',
            [
                'label' => esc_html__('Image Hover Overlay Display Type', 'themescamp-elements'),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'block' => esc_html__('Block', 'themescamp-elements'),
                    'none' => esc_html__('none', 'themescamp-elements'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .tcg-post-image::after' => 'display: {{VALUE}};',
                ],
                'condition' => [
                    'image_hover_overlay' => 'yes'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'image_hover_overlay_bg',
                'selector' => '{{WRAPPER}} .tcg-post-image::after',
                'types' => [ 'classic', 'gradient', 'tcg_gradient' ],
                'condition' => [
                    'image_hover_overlay' => 'yes'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'image_hover_overlay_border',
                'selector' => '{{WRAPPER}} .tcg-post-image::after',
                'condition' => [
                    'image_hover_overlay' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'image_hover_overlay_opacity',
            [
                'label' => esc_html__( 'Opacity', 'themescamp-elements' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 1,
                        'min' => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .tcg-post-image::after' => 'opacity: {{SIZE}};',
                ],
                'condition' => [
                    'image_hover_overlay' => 'yes'
                ]
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'image_hover_overlay_hover_tab',
            [
                'label'   => esc_html__( 'Hover', 'themescamp-plugin' ),
                'condition' => [
                    'image_hover_overlay' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'image_hover_overlay_display_hover',
            [
                'label' => esc_html__('Image Hover Overlay Display Type', 'themescamp-elements'),
                'type' => Controls_Manager::SELECT,
                'default' => 'block',
                'options' => [
                    'block' => esc_html__('Block', 'themescamp-elements'),
                    'none' => esc_html__('none', 'themescamp-elements'),
                ],
                'selectors' => [
                    '.e-con:hover .elementor-widget-tcg-post-featured-image>.elementor-widget-container>.tcg-post-image.selector-type-container.tcg-post-image-container-active:after' => 'display: {{VALUE}};',
                    '{{WRAPPER}} .tcg-post-image.selector-type-image:hover:after' => 'display: {{VALUE}};',
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'image_hover_overlay_bg_hover',
                'selector' => '.e-con:hover .elementor-widget-tcg-post-featured-image>.elementor-widget-container>.tcg-post-image.selector-type-container.tcg-post-image-container-active:after ,{{WRAPPER}} .tcg-post-image.selector-type-image:hover:after',
                'types' => [ 'classic', 'gradient', 'tcg_gradient' ],
                'condition' => [
                    'image_hover_overlay' => 'yes'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'image_hover_overlay_border_hover',
                'selector' => '.e-con:hover .elementor-widget-tcg-post-featured-image>.elementor-widget-container>.tcg-post-image.selector-type-container.tcg-post-image-container-active:after , {{WRAPPER}} .tcg-post-image.selector-type-image:hover:after',
            ]
        );

        $this->add_control(
            'image_hover_overlay_opacity_hover',
            [
                'label' => esc_html__( 'Opacity', 'themescamp-elements' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 1,
                        'min' => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '.e-con:hover .elementor-widget-tcg-post-featured-image>.elementor-widget-container>.tcg-post-image.selector-type-container.tcg-post-image-container-active:after' => 'opacity: {{SIZE}};',
                    '{{WRAPPER}} .tcg-post-image.selector-type-image:hover:after' => 'opacity: {{SIZE}};',
                ],
                'condition' => [
                    'image_hover_overlay' => 'yes'
                ]
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();
        $this->add_control(
            'image_hover_overlay_content_divider',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $this->add_control(
            'image_hover_overlay_content',
            [
                'label' => esc_html__( 'Select Content', 'themescamp-plugin' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none' => esc_html__( 'None', 'themescamp-plugin' ),
                    'media'  => esc_html__( 'Media', 'themescamp-plugin' ),
                ],
            ]
        );

		$this->add_control(
			'media_type',
			[
				'label' => esc_html__('Media Type', 'themescamp-elements'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'icon' => [
						'title' => esc_html__('Icon', 'themescamp-elements'),
						'icon' => 'eicon-favorite',
					],
					'image' => [
						'title' => esc_html__('Image', 'themescamp-elements'),
						'icon' => 'eicon-image',
					],
				],
				'default' => 'icon',
                'condition' => ['image_hover_overlay_content'=>'media'],
			]
		);

		$this->add_control(
			'media_type_icon',
			[
				'label' => esc_html__('Icon', 'themescamp-elements'),
				'type' => Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'skin' => 'inline',
				'label_block' => false,
                'condition' => [
                    'image_hover_overlay_content'=>'media',
                    'media_type'=>'icon',
                ],
			]
		);
        
        $this->add_control(
			'media_type_image',
			[
				'label' => esc_html__( 'Choose Image', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
                'condition' => [
                    'image_hover_overlay_content'=>'media',
                    'media_type'=>'image',
                ],
			]
		);

        $this->add_responsive_control(
            'icon_container_height',
            [
                'label' => esc_html__( 'Icon Container Height', 'themescamp-elements' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'unit' => 'px',
                ],
                'tablet_default' => [
                    'unit' => 'px',
                ],
                'mobile_default' => [
                    'unit' => 'px',
                ],
                'size_units' => [ 'px', 'vh', '%', 'vw', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 500,
                    ],
                    'vh' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    '%' => [
                        'min' => 1,
                        'max' => 200,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .tcg-post-image .image-hover-container .tc-hover-media svg' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .tcg-post-image .image-hover-container .tc-hover-media img' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => ['image_hover_overlay_content!'=>'none'],
            ]
        );

        $this->add_responsive_control(
            'icon_container_width',
            [
                'label' => esc_html__( 'Icon Container Width', 'themescamp-elements' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'unit' => '%',
                ],
                'tablet_default' => [
                    'unit' => '%',
                ],
                'mobile_default' => [
                    'unit' => '%',
                ],
                'size_units' => [ '%', 'px', 'vw', 'rem', 'custom' ],
                'range' => [
                    '%' => [
                        'min' => 1,
                        'max' => 150,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 150,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .tcg-post-image .image-hover-container .tc-hover-media svg' => 'width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .tcg-post-image .image-hover-container .tc-hover-media i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .tcg-post-image .image-hover-container .tc-hover-media img' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => ['image_hover_overlay_content!'=>'none'],
            ]
        );

        $this->end_controls_section();
    }


	protected function render() {
    $settings = $this->get_settings_for_display();

        ?>
        
        <div class="tcg-post-image <?php echo 'selector-type-'.$settings['image_hover_overlay_selector'] ?>">

        <?php
        // Manually retrieve the post's featured image.
        if( has_post_thumbnail() ) {
            $post_thumbnail_id = get_post_thumbnail_id();
            $post_thumbnail_url = wp_get_attachment_url( $post_thumbnail_id );

            $link_start = '';
            $link_end = '';

            if($settings['link_to'] == 'post-url'): echo $link_start = '<a href="'.esc_url(get_the_permalink()).'">'; $link_end = '</a>'; endif; 
            echo $link_start;
            ?>
            <img src="<?php echo esc_url( $post_thumbnail_url ); ?>" alt="<?php echo esc_attr( get_the_title() ); ?>">
            <?php
            echo $link_end;
            if ($settings['image_hover_overlay_content']!='none') : ?>
                <div class="image-hover-container">
                    <?php if ($settings['image_hover_overlay_content']=='media' && $settings['media_type']=='icon') : ?>
                        <div class="tc-hover-media">
                            <?php \Elementor\Icons_Manager::render_icon( $settings['media_type_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                        </div>
                    <?php endif;?>
                    <?php if ($settings['image_hover_overlay_content']=='media' && $settings['media_type']=='image') : ?>
                        <div class="tc-hover-media">
                            <?php echo '<img src="' . $settings['media_type_image']['url'] . '">'; ?>
                        </div>
                    <?php endif;?>
                </div>
            <?php endif;
        } ?>

        </div>

    <?php }

}
