<?php
namespace ThemescampPlugin\Admin;

/**
 * Load Theme Admin
 */
class Themescamp_Admin_Panel {

    protected static $instance = null;


    public static function instance() {
        if ( null === self::$instance ) {
            self::$instance = new self();
        }

        return self::$instance;
    }


    public function initialize() {

        /* Add the registration custom page */ 
        add_action('admin_menu',[$this,'tcg_init_menu'],9);

        // Hook into the admin menu
        add_action('admin_menu', [$this,'system_page_submenu']);

        // Hook into the admin menu
        add_action('admin_menu', [$this,'themescamp_saved_options_submenu']);

        if (get_option('tcg_theme_status')=='active' || get_option('tcg_theme_dev_mod')){
            add_filter( 'ocdi/plugin_page_setup', [$this,'ocdi_plugin_page_setup'] );
        }

        //include options admin 
        include('option-init.php');

    }


    public function tcg_init_menu() {

        $menu_title = get_option('tcg_theme_name') ? ucfirst(get_option('tcg_theme_name')) : 'ThemesCamp';
        // $menu_title = 'ThemesCamp';

        
            add_menu_page(
                $menu_title,        // Page title
                $menu_title,        // Page title
                'manage_options',    // Capability to be displayed to the user
                'tcg_init',   // Menu slug : /admin.php?page=tcg_init
                [$this,'init_page'], // Callback of the function to be called to output the content for this page
                THEMESCAMP_URL . 'assets//img/dashboard-icon-tc.png',
                2
            );
        
        //function include_license_function() {
            if (get_option('tcg_theme_id')){
                add_submenu_page(
                    'tcg_init',    // Parent slug (use an existing admin menu)
                    'License',                // Page title
                    'License manager',                // Menu title
                    'manage_options',          // Capability to be displayed to the user
                    'registration',            // Sub-menu slug
                    'tcg_registration_page' // Callback function to output the content for this page
                );
           }
        //}

        // Hook your License function to a custom action hook 
        //add_action('tcg_include_license', 'include_license_function');

        add_submenu_page(
            'tcg_init',  // Parent slug 
            'Live Customizer', // Page title
            'Live Customizer', // Menu title
            'manage_options', // Capability to be displayed to the user
            'customize.php?return=' . urlencode(admin_url('admin.php?page=tcg_init')) // Callback
        );


    }

    // Add a submenu page without displaying it in the dashboard menu
    function system_page_submenu() {
        if (get_option('tcg_theme_status')=='active' || get_option('tcg_theme_dev_mod')){
            add_submenu_page(
                'tcg_init',          // Parent slug
                'System Settings',            // Page title
                'System Settings',            // Menu title
                'manage_options',           // Capability to be displayed to the user
                'system-settings-page',       // Sub-menu slug : /admin.php?page=systen-settings-page
                [$this,'system_page']    // Callback of the function to be called to output the content for this page
            );
        }
    }

    // Add a submenu page without displaying it in the dashboard menu
    public function themescamp_saved_options_submenu() {
        add_submenu_page(
            '', // Set this to null to avoid displaying in the dashboard menu
            'All Saved Options',
            'All Options',
            'manage_options',
            'all-saved-options',
            [$this,'display_options_page']
        );
    }

    public function ocdi_plugin_page_setup( $default_settings ) {
        $default_settings['parent_slug'] = 'tcg_init';
        $default_settings['page_title']  = esc_html__( 'One Click Demo Import' , 'one-click-demo-import' );
        $default_settings['menu_title']  = esc_html__( 'Import Demo' , 'one-click-demo-import' );
        $default_settings['capability']  = 'import';
        $default_settings['menu_slug']   = 'one-click-demo-import';
     
        return $default_settings;
    }

    public function init_page(){

        require_once('admin-welcome-page.php');

    }

    public function system_page(){
        require_once('admin-status-page.php');
    }

    public function display_options_page(){
        require_once('display-options.php');
    }


    /**
     * Let to Number
     *
     * @return void
     */
    public function let_to_num( $v ) {
        $l   = substr( $v, -1 );
        $ret = substr( $v, 0, -1 );
        switch ( strtoupper( $l ) ) {
        case 'P':$ret *= 1024;
        case 'T':$ret *= 1024;
        case 'G':$ret *= 1024;
        case 'M':$ret *= 1024;
        case 'K':$ret *= 1024;
            break;
        }

        return $ret;
    }

    /**
     * Memory Limit
     *
     * @return void
     */
    public function memory_limit() {
        $limit = $this->let_to_num( WP_MEMORY_LIMIT );
        if ( function_exists( 'memory_get_usage' ) ) {
            $limit = max( $limit, $this->let_to_num( @ini_get( 'memory_limit' ) ) );
        }

        return $limit;
    }

}
Themescamp_Admin_Panel::instance()->initialize();