<?php
// Registers the new post type 

function themescamp_portfolio_post_type() {
	register_post_type( 'portfolio',
		array(
			'labels' => array(
				'name' => __( 'Portfolios', 'themescamp-core' ),
				'singular_name' => __( 'Portfolio' , 'themescamp-core'),
				'add_new' => __( 'Add New Portfolio', 'themescamp-core' ),
				'add_new_item' => __( 'Add New Portfolio', 'themescamp-core' ),
				'edit_item' => __( 'Edit Portfolio', 'themescamp-core' ),
				'new_item' => __( 'Add New Portfolio', 'themescamp-core' ),
				'view_item' => __( 'View Portfolio', 'themescamp-core' ),
				'search_items' => __( 'Search Portfolio', 'themescamp-core' ),
				'not_found' => __( 'No Portfolio found', 'themescamp-core' ),
				'not_found_in_trash' => __( 'No Portfolio found in trash', 'themescamp-core' )
			),
			'public' => true,
			'has_archive' => true,
			'supports' => array( 'title','editor', 'thumbnail', 'comments' , 'excerpt'),
			'capability_type' => 'post',
			'rewrite' => array("slug" => "portfolio"), // Permalinks format
			'menu_position' => 5,
			'menu_icon'           => 'dashicons-align-center',
			'exclude_from_search' => true,
			'taxonomies'  => array( 'portfolio', 'portfolio_category' ), 
		)
	);
}

add_action( 'init', 'themescamp_portfolio_post_type' );

//add taxonomies(portfolio category)
function themescamp_taxonomies_portfolio() {
	$labels = array(
		'name'              => _x( 'Portfolio Categories', 'taxonomy general name' ),
		'singular_name'     => _x( 'Portfolio Category', 'taxonomy singular name' ),
		'search_items'      => __( 'Search Portfolio Categories' ),
		'all_items'         => __( 'All Portfolio Categories' ),
		'parent_item'       => __( 'Parent Portfolio Category' ),
		'parent_item_colon' => __( 'Parent Portfolio Category:' ),
		'edit_item'         => __( 'Edit Portfolio Category' ), 
		'update_item'       => __( 'Update Portfolio Category' ),
		'add_new_item'      => __( 'Add New Portfolio Category' ),
		'new_item_name'     => __( 'New Portfolio Category' ),
		'menu_name'         => __( 'Portfolio Categories' ),
	);
	$args = array(
		'labels' => $labels,
		'hierarchical' => true,
		'has_archive' => true, 
	);
	register_taxonomy( 'portfolio_category', 'portfolio', $args );
}
add_action( 'init', 'themescamp_taxonomies_portfolio', 0 );

//add taxonomies(portfolio tag)
function themescamp_taxonomies_portfolio_tag() {
	$labels = array(
		'name'              => _x( 'Portfolio Tags', 'taxonomy general name' ),
		'singular_name'     => _x( 'Portfolio Tag', 'taxonomy singular name' ),
		'search_items'      => __( 'Search Portfolio Tags' ),
		'all_items'         => __( 'All Portfolio Tags' ),
		'edit_item'         => __( 'Edit Portfolio Tag' ), 
		'update_item'       => __( 'Update Portfolio Tag' ),
		'add_new_item'      => __( 'Add New Portfolio Tag' ),
		'new_item_name'     => __( 'New Portfolio Tag' ),
		'menu_name'         => __( 'Portfolio Tags' ),
		'parent_item' => null,
		'parent_item_colon' => null,
		'separate_items_with_commas' => __( 'Separate tags with commas' ),
		'add_or_remove_items' => __( 'Add or remove tags' ),
		'choose_from_most_used' => __( 'Choose from the most used tags' ),
	);
	$args = array(
		'labels' => $labels,
		'hierarchical' => false,
		'rewrite' => true,
		'query_var' => true,
		'has_archive' => true,
	);
	register_taxonomy( 'porto_tag', 'portfolio', $args );
}
add_action( 'init', 'themescamp_taxonomies_portfolio_tag', 0 );

